#include "stdafx.h"
#include "test_funcs.h"
#include <scpl/FBuffer.h>

using namespace scpl;

static long p[10] = {1,3,5,4,2,6,7,9,8,0};

void test_FBuffer(){
	FBuffer<long,10> ib(true);
	FBuffer<long,10> ib2(p,10);

	SUT_ASSERT_EQUALS(Int,ib.count(),10);
	SUT_ASSERT_EQUALS(Int,ib2.count(),10);
	SUT_ASSERT_EQUALS(Ptr,(const long*)ib,ib.get());
	SUT_ASSERT_EQUALS(Ptr,ib.begin(),ib.get());
	SUT_ASSERT_EQUALS(Ptr,ib.end(),ib.get()+ib.count());
	SUT_ASSERT_EQUALS(Ptr,ib.rbegin(),ib.get()+ib.count()-1);
	SUT_ASSERT_EQUALS(Ptr,ib.rend(),ib.get()-1);
	SUT_ASSERT(!ib.equals(ib2));
	SUT_ASSERT(ib != ib2);

	SUT_CHECK_EQUALS(Int,ib.get()[0],0);
	SUT_CHECK_EQUALS(Int,ib.get()[1],0);
	SUT_CHECK_EQUALS(Int,ib.get()[2],0);
	SUT_CHECK_EQUALS(Int,ib.get()[3],0);
	SUT_CHECK_EQUALS(Int,ib.get()[4],0);
	SUT_CHECK_EQUALS(Int,ib.get()[5],0);
	SUT_CHECK_EQUALS(Int,ib.get()[6],0);
	SUT_CHECK_EQUALS(Int,ib.get()[7],0);
	SUT_CHECK_EQUALS(Int,ib.get()[8],0);
	SUT_CHECK_EQUALS(Int,ib.get()[9],0);
	SUT_CHECK_EQUALS(Int,ib2.get()[0],1);
	SUT_CHECK_EQUALS(Int,ib2.get()[1],3);
	SUT_CHECK_EQUALS(Int,ib2.get()[2],5);
	SUT_CHECK_EQUALS(Int,ib2.get()[3],4);
	SUT_CHECK_EQUALS(Int,ib2.get()[4],2);
	SUT_CHECK_EQUALS(Int,ib2.get()[5],6);
	SUT_CHECK_EQUALS(Int,ib2.get()[6],7);
	SUT_CHECK_EQUALS(Int,ib2.get()[7],9);
	SUT_CHECK_EQUALS(Int,ib2.get()[8],8);
	SUT_CHECK_EQUALS(Int,ib2.get()[9],0);

	ib = ib2;
	SUT_ASSERT(ib.equals(ib2));
	SUT_ASSERT(ib2 == ib);
	SUT_ASSERT_EQUALS(Int,ib.count(),10);
	SUT_ASSERT_EQUALS(Int,ib.size(),sizeof(long)*10);

	SUT_ASSERT_EQUALS(Int,ib.toPos(ib.get()+0),0);
	SUT_ASSERT_EQUALS(Int,ib.toPos(ib.get()+1),1);
	SUT_ASSERT_EQUALS(Int,ib.toPos(ib.get()+2),2);
	SUT_ASSERT_EQUALS(Int,ib.toPos(ib.get()+3),3);
	SUT_ASSERT_EQUALS(Int,ib.toPos(ib.get()+4),4);
	SUT_ASSERT_EQUALS(Int,ib.toPos(ib.get()+5),5);
	SUT_ASSERT_EQUALS(Int,ib.toPos(ib.get()+6),6);
	SUT_ASSERT_EQUALS(Int,ib.toPos(ib.get()+7),7);
	SUT_ASSERT_EQUALS(Int,ib.toPos(ib.get()+8),8);
	SUT_ASSERT_EQUALS(Int,ib.toPos(ib.get()+9),9);

}