#include "stdafx.h"
#include "test_funcs.h"
#include <scpl/List.h>
#include "CountStruct.h"

using namespace scpl;

typedef CList<CountStruct> CSCList;
typedef DList<long> CSDList;
typedef CFList<CountStruct,10> CSCFList;
typedef DFList<ushort,10> CSDFList;

#define check_isEmpty(scl,cap)\
	SUT_ASSERT(scl.empty());\
	SUT_ASSERT_EQUALS(Int,scl.count(),0);\
	SUT_ASSERT_EQUALS(Int,scl.capacity(),cap);\
	SUT_ASSERT(scl.begin() == NULL);\
	SUT_ASSERT(scl.end() == NULL);\
	SUT_ASSERT(scl.rbegin() == NULL);\
	SUT_ASSERT(scl.rend() == NULL)

#define check_isNoEmpty(scl,cnt,cap)\
	SUT_ASSERT(!scl.empty());\
	SUT_ASSERT_EQUALS(Int,scl.count(),cnt);\
	SUT_ASSERT_EQUALS(Int,scl.capacity(),cap);\
	SUT_ASSERT(scl.begin() != NULL);\
	SUT_ASSERT(scl.end() != NULL);\
	SUT_ASSERT(scl.rbegin() != NULL);\
	SUT_ASSERT(scl.rend() != NULL);\
	SUT_ASSERT_EQUALS(Int,(int)(scl.end() - scl.begin()),cnt);\
	SUT_ASSERT_EQUALS(Int,(int)(scl.rbegin() - scl.rend()),cnt)

void test_CList(){
	{
		CSCList a;
		CSCList b(10);

		SUT_ASSERT(a.empty());
		SUT_ASSERT_EQUALS(Int,a.count(),0);
		SUT_ASSERT_EQUALS(Int,a.capacity(),0);
		SUT_ASSERT(a.begin() == NULL);
		SUT_ASSERT(a.end() == NULL);
		SUT_ASSERT(a.rbegin() == NULL);
		SUT_ASSERT(a.rend() == NULL);
		SUT_ASSERT(b.empty());
		SUT_ASSERT_EQUALS(Int,b.count(),0);
		SUT_ASSERT_EQUALS(Int,b.capacity(),10);
		SUT_ASSERT(b.begin() == NULL);
		SUT_ASSERT(b.end() == NULL);
		SUT_ASSERT(b.rbegin() == NULL);
		SUT_ASSERT(b.rend() == NULL);
		check_isEmpty(b,10);

		SUT_ASSERT(a == b);

		SUT_ASSERT_EQUALS(Int,a.lastIn(CountStruct()),0);
		SUT_ASSERT_EQUALS(Int,a.lastIn(CountStruct()),1);
		SUT_ASSERT_EQUALS(Int,a.lastIn(CountStruct()),2);
		SUT_ASSERT_EQUALS(Int,a.lastIn(CountStruct()),3);
		SUT_ASSERT_EQUALS(Int,a.firstIn(CountStruct()),0);
		SUT_ASSERT_EQUALS(Int,a.firstIn(CountStruct()),0);
		SUT_ASSERT_EQUALS(Int,a.firstIn(CountStruct()),0);
		SUT_ASSERT_EQUALS(Int,a.firstIn(CountStruct()),0);
		SUT_ASSERT_EQUALS(Int,CountStruct::getCount(),8);

		SUT_ASSERT_EQUALS(Int,b.lastIn(CountStruct()),0);
		SUT_ASSERT_EQUALS(Int,b.lastIn(CountStruct()),1);
		SUT_ASSERT_EQUALS(Int,b.lastIn(CountStruct()),2);
		SUT_ASSERT_EQUALS(Int,b.lastIn(CountStruct()),3);
		SUT_ASSERT_EQUALS(Int,b.firstIn(CountStruct()),0);
		SUT_ASSERT_EQUALS(Int,b.firstIn(CountStruct()),0);
		SUT_ASSERT_EQUALS(Int,b.firstIn(CountStruct()),0);
		SUT_ASSERT_EQUALS(Int,b.firstIn(CountStruct()),0);
		SUT_ASSERT_EQUALS(Int,CountStruct::getCount(),16);

		check_isNoEmpty(a,8,8);
		check_isNoEmpty(b,8,10);

		SUT_ASSERT(a != b);//printf("------0\n");

		a = b;//printf("------0\n");

		SUT_ASSERT(a == b);
		SUT_ASSERT_EQUALS(Int,CountStruct::getCount(),16);
		check_isNoEmpty(a,8,8);//printf("======1\n");

		a.clear();//printf("======1\n");
		SUT_ASSERT(a != b);
		SUT_ASSERT_EQUALS(Int,CountStruct::getCount(),8);
		check_isEmpty(a,8);//printf("------2\n");

		a.lastInList(b);//printf("------2\n");
		SUT_ASSERT(a == b);
		SUT_ASSERT_EQUALS(Int,CountStruct::getCount(),16);
		check_isNoEmpty(a,8,8);//printf("======3\n");

		a.lastInList(b);//printf("======3\n");
		SUT_ASSERT(a != b);
		SUT_ASSERT_EQUALS(Int,CountStruct::getCount(),24);
		check_isNoEmpty(a,16,16);//printf("------4\n");

		b = a;//printf("------4\n");
		SUT_ASSERT(a == b);
		SUT_ASSERT_EQUALS(Int,CountStruct::getCount(),32);
		check_isNoEmpty(b,16,16);

		a.firstOut();
		//{
		//	CountStruct *ai=a.begin(),*ae=a.end();
		//	CountStruct *bi=b.begin(),*be=b.end();
		//	for(;ai<a;++it) printf("[%i]\n",);
		//}
		SUT_ASSERT_NOTEQUALS(Int,a.at(0).i,b.at(0).i);
		SUT_ASSERT_EQUALS(Int,a.at(0).i,b.at(1).i);
		SUT_ASSERT_EQUALS(Int,a[0].i,b[1].i);
		SUT_ASSERT_EQUALS(Int,a.atLast().i,b.atLast().i);

		b.lastOut();
		SUT_ASSERT_NOTEQUALS(Int,a.atLast().i,b.atLast().i);
		SUT_ASSERT_EQUALS(Int,a[a.count()-2].i,b.atLast().i);///
		check_isNoEmpty(b,15,16);
		check_isNoEmpty(b,15,16);
		SUT_ASSERT_EQUALS(Int,CountStruct::getCount(),30);
	}
	SUT_ASSERT_EQUALS(Int,CountStruct::getCount(),0);
}
void test_DList(){
	{
		CSDList a;
		CSDList b(10);

		check_isEmpty(a,0);
		check_isEmpty(b,10);

		SUT_ASSERT(a == b);

		SUT_ASSERT_EQUALS(Int,a.lastIn(6),0);
		SUT_ASSERT_EQUALS(Int,a.lastIn(4),1);
		SUT_ASSERT_EQUALS(Int,a.lastIn(7),2);
		SUT_ASSERT_EQUALS(Int,a.lastIn(1),3);
		SUT_ASSERT_EQUALS(Int,a.firstIn(3),0);
		SUT_ASSERT_EQUALS(Int,a.firstIn(2),0);
		SUT_ASSERT_EQUALS(Int,a.firstIn(9),0);
		SUT_ASSERT_EQUALS(Int,a.firstIn(0),0);

		SUT_ASSERT_EQUALS(Int,b.lastIn(6),0);
		SUT_ASSERT_EQUALS(Int,b.lastIn(4),1);
		SUT_ASSERT_EQUALS(Int,b.lastIn(7),2);
		SUT_ASSERT_EQUALS(Int,b.lastIn(1),3);
		SUT_ASSERT_EQUALS(Int,b.firstIn(3),0);
		SUT_ASSERT_EQUALS(Int,b.firstIn(2),0);
		SUT_ASSERT_EQUALS(Int,b.firstIn(9),0);
		SUT_ASSERT_EQUALS(Int,b.firstIn(0),0);

		check_isNoEmpty(a,8,8);
		check_isNoEmpty(b,8,10);

		SUT_ASSERT(a == b);

		a.clear();
		SUT_ASSERT(a != b);
		check_isEmpty(a,8);

		a.lastInList(b);
		SUT_ASSERT_EQUALS(Int,a.count(),b.count());
		SUT_ASSERT_EQUALS(Int,a[0],b[0]);
		SUT_ASSERT_EQUALS(Int,a[1],b[1]);
		SUT_ASSERT_EQUALS(Int,a[2],b[2]);
		SUT_ASSERT_EQUALS(Int,a[3],b[3]);
		SUT_ASSERT_EQUALS(Int,a[4],b[4]);
		SUT_ASSERT_EQUALS(Int,a[5],b[5]);
		SUT_ASSERT_EQUALS(Int,a[6],b[6]);
		SUT_ASSERT_EQUALS(Int,a[7],b[7]);
		SUT_ASSERT(a == b);
		check_isNoEmpty(a,8,8);

		a.lastInList(b);
		SUT_ASSERT(a != b);
		check_isNoEmpty(a,16,16);

		b = a;
		SUT_ASSERT(a == b);
		check_isNoEmpty(b,16,16);

		a.firstOut();
		SUT_ASSERT_NOTEQUALS(Int,a.at(0),b.at(0));
		SUT_ASSERT_EQUALS(Int,a.at(0),b.at(1));
		SUT_ASSERT_EQUALS(Int,a[0],b[1]);
		SUT_ASSERT_EQUALS(Int,a.atLast(),b.atLast());

		b.lastOut();
		SUT_ASSERT_NOTEQUALS(Int,a.atLast(),b.atLast());
		SUT_ASSERT_EQUALS(Int,a[a.count()-2],b.atLast());
		check_isNoEmpty(b,15,16);
		check_isNoEmpty(b,15,16);
	}
	{
		DList<CountStruct> a;
		SUT_ASSERT_EQUALS(Int,a.lastIn(CountStruct()),0);
		SUT_ASSERT_EQUALS(Int,a.firstIn(CountStruct()),0);
		SUT_ASSERT_EQUALS(Int,a.lastIn(CountStruct()),2);
		a.firstOut();
	}
	SUT_CHECK_EQUALS(Int,CountStruct::getCount(),0);
	CountStruct::reset();
}
void test_CFList(){
	{
		CSCFList a;
		CSCFList b;

		check_isEmpty(a,10);
		check_isEmpty(b,10);

		SUT_ASSERT(a == b);

		SUT_ASSERT_EQUALS(Int,CountStruct::getCount(),0);

		SUT_ASSERT_EQUALS(Int,a.lastIn(CountStruct()),0);
		SUT_ASSERT_EQUALS(Int,a.lastIn(CountStruct()),1);
		SUT_ASSERT_EQUALS(Int,a.lastIn(CountStruct()),2);
		SUT_ASSERT_EQUALS(Int,a.lastIn(CountStruct()),3);
		SUT_ASSERT_EQUALS(Int,a.firstIn(CountStruct()),0);
		SUT_ASSERT_EQUALS(Int,a.firstIn(CountStruct()),0);
		SUT_ASSERT_EQUALS(Int,a.firstIn(CountStruct()),0);
		SUT_ASSERT_EQUALS(Int,a.firstIn(CountStruct()),0);
		SUT_ASSERT_EQUALS(Int,CountStruct::getCount(),8);

		SUT_ASSERT_EQUALS(Int,b.lastIn(CountStruct()),0);
		SUT_ASSERT_EQUALS(Int,b.lastIn(CountStruct()),1);
		SUT_ASSERT_EQUALS(Int,b.lastIn(CountStruct()),2);
		SUT_ASSERT_EQUALS(Int,b.lastIn(CountStruct()),3);
		SUT_ASSERT_EQUALS(Int,b.firstIn(CountStruct()),0);
		SUT_ASSERT_EQUALS(Int,b.firstIn(CountStruct()),0);
		SUT_ASSERT_EQUALS(Int,b.firstIn(CountStruct()),0);
		SUT_ASSERT_EQUALS(Int,b.firstIn(CountStruct()),0);
		SUT_ASSERT_EQUALS(Int,CountStruct::getCount(),16);

		check_isNoEmpty(a,8,10);
		check_isNoEmpty(b,8,10);

		SUT_ASSERT(a != b);

		a = b;

		SUT_ASSERT(a == b);
		SUT_ASSERT_EQUALS(Int,CountStruct::getCount(),16);
		check_isNoEmpty(a,8,10);

		a.clear();
		SUT_ASSERT(a != b);
		SUT_ASSERT_EQUALS(Int,CountStruct::getCount(),8);
		check_isEmpty(a,10);

		a.lastInList(b);
		SUT_ASSERT(a == b);
		SUT_ASSERT_EQUALS(Int,CountStruct::getCount(),16);
		check_isNoEmpty(a,8,10);

		try{a.lastInList(b);SUT_ASSERT(false);}catch(std::runtime_error){}
		SUT_ASSERT(a == b);
		SUT_ASSERT_EQUALS(Int,CountStruct::getCount(),16);
		check_isNoEmpty(a,8,10);

		a.firstOut();
		SUT_ASSERT_NOTEQUALS(Int,a.at(0).i,b.at(0).i);
		SUT_ASSERT_EQUALS(Int,a.at(0).i,b.at(1).i);
		SUT_ASSERT_EQUALS(Int,a[0].i,b[1].i);
		SUT_ASSERT_EQUALS(Int,a.atLast().i,b.atLast().i);

		b.lastOut();
		SUT_ASSERT_NOTEQUALS(Int,a.atLast().i,b.atLast().i);
		SUT_ASSERT_EQUALS(Int,a[a.count()-2].i,b.atLast().i);
		check_isNoEmpty(b,7,10);
		check_isNoEmpty(b,7,10);
		SUT_ASSERT_EQUALS(Int,CountStruct::getCount(),14);
	}
	SUT_ASSERT_EQUALS(Int,CountStruct::getCount(),0);
}
void test_DFList(){
	{
		CSDFList a;
		CSDFList b;

		check_isEmpty(a,10);
		check_isEmpty(b,10);

		SUT_ASSERT(a == b);

		SUT_ASSERT_EQUALS(Int,a.lastIn(6),0);
		SUT_ASSERT_EQUALS(Int,a.lastIn(4),1);
		SUT_ASSERT_EQUALS(Int,a.lastIn(7),2);
		SUT_ASSERT_EQUALS(Int,a.lastIn(1),3);
		SUT_ASSERT_EQUALS(Int,a.firstIn(3),0);
		SUT_ASSERT_EQUALS(Int,a.firstIn(2),0);
		SUT_ASSERT_EQUALS(Int,a.firstIn(9),0);
		SUT_ASSERT_EQUALS(Int,a.firstIn(0),0);

		SUT_ASSERT_EQUALS(Int,b.lastIn(6),0);
		SUT_ASSERT_EQUALS(Int,b.lastIn(4),1);
		SUT_ASSERT_EQUALS(Int,b.lastIn(7),2);
		SUT_ASSERT_EQUALS(Int,b.lastIn(1),3);
		SUT_ASSERT_EQUALS(Int,b.firstIn(3),0);
		SUT_ASSERT_EQUALS(Int,b.firstIn(2),0);
		SUT_ASSERT_EQUALS(Int,b.firstIn(9),0);
		SUT_ASSERT_EQUALS(Int,b.firstIn(0),0);

		check_isNoEmpty(a,8,10);
		check_isNoEmpty(b,8,10);

		SUT_ASSERT(a == b);

		a.clear();
		SUT_ASSERT(a != b);
		check_isEmpty(a,10);

		a.lastInList(b);
		SUT_ASSERT(a == b);
		check_isNoEmpty(a,8,10);

		try{a.lastInList(b);SUT_ASSERT(false);}catch(std::runtime_error){}
		SUT_ASSERT(a == b);
		check_isNoEmpty(a,8,10);

		a.firstOut();
		SUT_ASSERT_NOTEQUALS(Int,a.at(0),b.at(0));
		SUT_ASSERT_EQUALS(Int,a.at(0),b.at(1));
		SUT_ASSERT_EQUALS(Int,a[0],b[1]);
		SUT_ASSERT_EQUALS(Int,a.atLast(),b.atLast());

		b.lastOut();
		SUT_ASSERT_NOTEQUALS(Int,a.atLast(),b.atLast());
		SUT_ASSERT_EQUALS(Int,a[a.count()-2],b.atLast());
		check_isNoEmpty(b,7,10);
		check_isNoEmpty(b,7,10);
	}
	{
		DFList<CountStruct,2> a;
		SUT_ASSERT_EQUALS(Int,a.lastIn(CountStruct()),0);
		SUT_ASSERT_EQUALS(Int,a.lastIn(CountStruct()),1);
		try{a.lastIn(CountStruct());SUT_ASSERT(false);}catch(std::runtime_error){}
	}
	SUT_CHECK_EQUALS(Int,CountStruct::getCount(),0);
	CountStruct::reset();
}
