#include "stdafx.h"
#include "test_funcs.h"
#include <scpl/Queue.h>
#include "CountStruct.h"

using namespace scpl;

typedef CQueue<CountStruct>		CSCQ;
typedef DQueue<double>			IDQ;
typedef CFQueue<CountStruct,3>	CSCFQ;
typedef DFQueue<long,3>			LDFQ;

TMP void check(const IQueue<T>* lq,ulong cnt,ulong cap){
	if(cnt == 0) SUT_ASSERT(lq->empty());
	else SUT_ASSERT(!lq->empty());
	SUT_ASSERT_EQUALS(Int,lq->count(),cnt);
	SUT_ASSERT_EQUALS(Int,lq->capacity(),cap);
}

TMP void checkPop(IQueue<T>* lq,const T& e,bool ok){
	try{
		T t = lq->get();
		SUT_ASSERT_EQUALS(Int,t,e);
		lq->pop();
		if(!ok) SUT_ASSERT(false);
	}catch(std::runtime_error){if(ok) SUT_ASSERT(false);}
}
template<> void checkPop(IQueue<CountStruct>* lq,const CountStruct& e,bool ok){
	try{
		CountStruct t(lq->get());
		SUT_ASSERT_EQUALS(Int,t.i,e.i);
		lq->pop();
		if(!ok) SUT_ASSERT(false);
	}catch(std::runtime_error){if(ok) SUT_ASSERT(false);}
}
template<> void checkPop(IQueue<double>* lq,const double& e,bool ok){
	try{
		double t = lq->get();
		SUT_ASSERT_EQUALS(Dbl,t,e);
		lq->pop();
		if(!ok) SUT_ASSERT(false);
	}catch(std::runtime_error){if(ok) SUT_ASSERT(false);}
}
TMP void checkPush(IQueue<T>* lq,const T& e,bool ok){
	try{
		lq->push(e);
		if(!ok) SUT_ASSERT(false);
	}catch(std::runtime_error){if(ok) SUT_ASSERT(false);}
}

#define flow_(F) try{F;}catch(scpl::sut::sut_assert s){printf("(In Line:%5i)\n",__LINE__);throw s;}

void test_CQueue(){
	{
		CountStruct cs[5];
		CSCQ a;
		CSCQ b(3);

		flow_(check(&a,0,0));
		flow_(check(&b,0,3));

		flow_(checkPush(&a,cs[0],false));
		flow_(checkPush(&b,cs[0],true));
		flow_(check(&b,1,3));
		flow_(checkPush(&b,cs[1],true));
		flow_(checkPush(&b,cs[2],true));
		flow_(check(&b,3,3));
		flow_(checkPush(&b,cs[3],false));
		SUT_CHECK_EQUALS(Int,CountStruct::getCount(),8);

		a.adjust(2);
		flow_(check(&a,0,2));
		flow_(checkPush(&a,cs[1],true));
		flow_(checkPush(&a,cs[2],true));
		flow_(check(&a,2,2));
		flow_(checkPush(&a,cs[3],false));
		SUT_CHECK_EQUALS(Int,CountStruct::getCount(),10);

		flow_(checkPop(&a,cs[1],true));
		flow_(checkPop(&a,cs[2],true));
		flow_(checkPop(&a,cs[0],false));
		
		SUT_CHECK_EQUALS(Int,CountStruct::getCount(),8);

		a = b;
		SUT_CHECK_EQUALS(Int,CountStruct::getCount(),11);

		flow_(checkPop(&a,cs[0],true));
		flow_(checkPop(&a,cs[1],true));
		flow_(checkPop(&a,cs[2],true));
		flow_(checkPop(&a,cs[2],false));
		
		SUT_CHECK_EQUALS(Int,CountStruct::getCount(),8);

		flow_(check(&a,0,3));
		a.adjust(8);
		flow_(check(&a,0,8));

		SUT_CHECK(a != b);
		a = b;
		SUT_CHECK(a == b);
		flow_(checkPop(&b,cs[0],true));
		flow_(checkPop(&b,cs[1],true));
		flow_(checkPop(&b,cs[2],true));
		flow_(checkPop(&b,cs[2],false));
		flow_(checkPop(&a,cs[0],true));
		flow_(checkPop(&a,cs[1],true));
		flow_(checkPop(&a,cs[2],true));
		flow_(checkPop(&a,cs[2],false));
		SUT_CHECK(a == b);

	}
	SUT_CHECK_EQUALS(Int,CountStruct::getCount(),0);
}
void test_DQueue(){
	{
		double cs[5]={9.254,1.234,8.4,0.09983,88.8};
		IDQ a;
		IDQ b(3);

		flow_(check(&a,0,0));
		flow_(check(&b,0,3));

		flow_(checkPush(&a,cs[0],false));
		flow_(checkPush(&b,cs[0],true));
		flow_(check(&b,1,3));
		flow_(checkPush(&b,cs[1],true));
		flow_(checkPush(&b,cs[2],true));
		flow_(check(&b,3,3));
		flow_(checkPush(&b,cs[3],false));

		a.adjust(2);
		flow_(check(&a,0,2));
		flow_(checkPush(&a,cs[1],true));
		flow_(checkPush(&a,cs[2],true));
		flow_(check(&a,2,2));
		flow_(checkPush(&a,cs[3],false));

		flow_(checkPop(&a,cs[1],true));
		flow_(checkPop(&a,cs[2],true));
		flow_(checkPop(&a,cs[0],false));
		
		a = b;

		flow_(checkPop(&a,cs[0],true));
		flow_(checkPop(&a,cs[1],true));
		flow_(checkPop(&a,cs[2],true));
		flow_(checkPop(&a,cs[2],false));
		
		flow_(check(&a,0,3));
		a.adjust(8);
		flow_(check(&a,0,8));

		SUT_CHECK(a != b);
		a = b;
		SUT_CHECK(a == b);

	}
	{
		CountStruct cs;
		DQueue<CountStruct> q(3);
		flow_(checkPush(&q,cs,true));
		flow_(checkPush(&q,cs,true));
		flow_(checkPush(&q,cs,true));
		flow_(checkPush(&q,cs,false));
	}
	SUT_CHECK_EQUALS(Int,CountStruct::getCount(),0);
	CountStruct::reset();
}
void test_CFQueue(){
	{
		CountStruct cs[5];
		CSCFQ a;
		CSCFQ b;

		flow_(check(&a,0,3));
		flow_(check(&b,0,3));

		flow_(checkPush(&a,cs[0],true));
		flow_(checkPush(&b,cs[0],true));
		flow_(check(&b,1,3));
		flow_(checkPush(&b,cs[1],true));
		flow_(checkPush(&b,cs[2],true));
		flow_(check(&b,3,3));
		flow_(checkPush(&b,cs[3],false));
		SUT_CHECK_EQUALS(Int,CountStruct::getCount(),9);

		flow_(check(&a,1,3));
		flow_(checkPush(&a,cs[1],true));
		flow_(checkPush(&a,cs[2],true));
		flow_(check(&a,3,3));
		flow_(checkPush(&a,cs[3],false));
		SUT_CHECK_EQUALS(Int,CountStruct::getCount(),11);

		flow_(checkPop(&a,cs[0],true));
		flow_(checkPop(&a,cs[1],true));
		flow_(checkPop(&a,cs[2],true));
		flow_(checkPop(&a,cs[0],false));
		
		SUT_CHECK_EQUALS(Int,CountStruct::getCount(),8);

		a = b;
		SUT_CHECK_EQUALS(Int,CountStruct::getCount(),11);

		flow_(checkPop(&a,cs[0],true));
		flow_(checkPop(&a,cs[1],true));
		flow_(checkPop(&a,cs[2],true));
		flow_(checkPop(&a,cs[2],false));
		
		SUT_CHECK_EQUALS(Int,CountStruct::getCount(),8);

		flow_(check(&a,0,3));

		SUT_CHECK(a != b);
		a = b;
		SUT_CHECK(a == b);

	}
	SUT_CHECK_EQUALS(Int,CountStruct::getCount(),0);
}
void test_DFQueue(){
	{
		long cs[5]={234,4856,23,4568,6432};
		LDFQ a;
		LDFQ b;

		flow_(check(&a,0,3));
		flow_(check(&b,0,3));

		flow_(checkPush(&a,cs[0],true));
		flow_(checkPush(&b,cs[0],true));
		flow_(check(&b,1,3));
		flow_(checkPush(&b,cs[1],true));
		flow_(checkPush(&b,cs[2],true));
		flow_(check(&b,3,3));
		flow_(checkPush(&b,cs[3],false));

		flow_(check(&a,1,3));
		flow_(checkPush(&a,cs[1],true));
		flow_(checkPush(&a,cs[2],true));
		flow_(check(&a,3,3));
		flow_(checkPush(&a,cs[3],false));

		flow_(checkPop(&a,cs[0],true));
		flow_(checkPop(&a,cs[1],true));
		flow_(checkPop(&a,cs[2],true));
		flow_(checkPop(&a,cs[0],false));
		
		a = b;

		flow_(checkPop(&a,cs[0],true));
		flow_(checkPop(&a,cs[1],true));
		flow_(checkPop(&a,cs[2],true));
		flow_(checkPop(&a,cs[2],false));
		
		flow_(check(&a,0,3));

		SUT_CHECK(a != b);
		a = b;
		SUT_CHECK(a == b);

	}
	{
		CountStruct cs;
		DQueue<CountStruct> q(3);
		flow_(checkPush(&q,cs,true));
		flow_(checkPush(&q,cs,true));
		flow_(checkPush(&q,cs,true));
		flow_(checkPush(&q,cs,false));
	}
	SUT_CHECK_EQUALS(Int,CountStruct::getCount(),0);
	CountStruct::reset();
}
