#include "stdafx.h"
#include "test_funcs.h"
#include <scpl/Range.h>

using namespace scpl;

typedef Range<char> CRange;
typedef Range<byte> BRange;
typedef Range<uint> URange;

TMP void checkstate(const Range<T>& r,bool min,bool max,bool fixed,T tmin,T tmax,T tval){
	SUT_ASSERT(r.isMin() == min);
	SUT_ASSERT(r.isMax() == max);
	SUT_ASSERT(r.isFixed() == fixed);
	SUT_ASSERT_EQUALS(Int,r.getMin(),tmin);
	SUT_ASSERT_EQUALS(Int,r.getMax(),tmax);
	SUT_ASSERT_EQUALS(Int,r.getVal(),tval);
	SUT_ASSERT_EQUALS(Int,r,tval);
}

TMP int check_plus(Range<T>& r){
	int count = 0;
	while(!r.isMax()){
		++r;++count;
	}
	return count;
}
TMP int check_minus(Range<T>& r){
	int count = 0;
	while(!r.isMin()){
		--r;++count;
	}
	return count;
}

TMP void checkprogress(const Range<T>& r,T p,T rp,int ip,int irp,double dp,double drp,float fp,float frp){
	SUT_ASSERT_EQUALS(Int,r.getProgress(),p);
	SUT_ASSERT_EQUALS(Int,r.getRProgress(),rp);
	SUT_ASSERT_EQUALS(Int,r.getProgressParInt(),ip);
	SUT_ASSERT_EQUALS(Int,r.getRProgressParInt(),irp);
	SUT_ASSERT_EQUALS(Dbl,r.getProgressParDouble(),dp);
	SUT_ASSERT_EQUALS(Dbl,r.getRProgressParDouble(),drp);
	SUT_ASSERT_EQUALS(Dbl,r.getProgressParFloat(),fp);
	SUT_ASSERT_EQUALS(Dbl,r.getRProgressParFloat(),frp);
}

#define flow_(F) try{F;}catch(scpl::sut::sut_assert s){printf("(In Line:%5i)\n",__LINE__);throw s;}

void tr_c(){
	CRange a;
	CRange b(10,20);
	CRange c(30,20);
	CRange d(10,20,15);
	CRange e(100,50,25);
	CRange f(1,1,1);

	flow_(checkstate<char>(a,true ,false,false,0,100,0));
	flow_(checkstate<char>(b,true ,false,false,10,20,10));
	flow_(checkstate<char>(c,true ,true ,true ,30,30,30));
	flow_(checkstate<char>(d,false,false,false,10,20,15));
	flow_(checkstate<char>(e,true ,false,false,25,50,25));
	flow_(checkstate<char>(f,true ,true ,true ,1,1,1));

	SUT_ASSERT_EQUALS(Int,check_plus(a),100);
	SUT_ASSERT_EQUALS(Int,check_plus(b),10);
	SUT_ASSERT_EQUALS(Int,check_plus(c),0);
	SUT_ASSERT_EQUALS(Int,check_plus(d),5);
	SUT_ASSERT_EQUALS(Int,check_plus(e),25);
	SUT_ASSERT_EQUALS(Int,check_plus(f),0);

	SUT_ASSERT_EQUALS(Int,check_minus(a),100);
	SUT_ASSERT_EQUALS(Int,check_minus(b),10);
	SUT_ASSERT_EQUALS(Int,check_minus(c),0);
	SUT_ASSERT_EQUALS(Int,check_minus(d),10);
	SUT_ASSERT_EQUALS(Int,check_minus(e),25);
	SUT_ASSERT_EQUALS(Int,check_minus(f),0);

	a.setMin(-100);
	b.setMax(110);
	c.setVal(5);
	d.set(0,40);
	e.set(20,20);
	f.set(1,21,1);

	flow_(checkstate<char>(a,false,false,false,-100,100,0));
	flow_(checkstate<char>(b,true ,false,false,10,110,10));
	flow_(checkstate<char>(c,true ,true ,true ,30,30,30));
	flow_(checkstate<char>(d,false,false,false,0,40,10));
	flow_(checkstate<char>(e,false,true ,false,20,25,25));
	flow_(checkstate<char>(f,true ,false,false,1,21,1));

	flow_(checkprogress<char>(a,100,100, 50, 50,0.5,0.5,0.5f,0.5f));
	flow_(checkprogress<char>(b,  0,100,  0,100,0.0,1.0,0.0f,1.0f));
	flow_(checkprogress<char>(c,  0,  0,  0,  0,0.0,0.0,0.0f,0.0f));
	flow_(checkprogress<char>(d, 10, 30, 25, 75,0.25,0.75,0.25f,0.75f));
	flow_(checkprogress<char>(e,  5,  0,100,  0,1.0,0.0,1.0f,0.0f));
	flow_(checkprogress<char>(f,  0, 20,  0,100,0.0,1.0,0.0f,1.0f));

	a += 127;SUT_ASSERT_EQUALS(Int,a,100);
	b += 127;SUT_ASSERT_EQUALS(Int,b,110);
	c += 127;SUT_ASSERT_EQUALS(Int,c,30);

}
void tr_b(){
	BRange a;
	BRange b(10,20);
	BRange c(30,20);
	BRange d(10,20,15);
	BRange e(100,50,25);
	BRange f(1,1,1);

	flow_(checkstate<byte>(a,true ,false,false,0,100,0));
	flow_(checkstate<byte>(b,true ,false,false,10,20,10));
	flow_(checkstate<byte>(c,true ,true ,true ,30,30,30));
	flow_(checkstate<byte>(d,false,false,false,10,20,15));
	flow_(checkstate<byte>(e,true ,false,false,25,50,25));
	flow_(checkstate<byte>(f,true ,true ,true ,1,1,1));

	SUT_ASSERT_EQUALS(Int,check_plus(a),100);
	SUT_ASSERT_EQUALS(Int,check_plus(b),10);
	SUT_ASSERT_EQUALS(Int,check_plus(c),0);
	SUT_ASSERT_EQUALS(Int,check_plus(d),5);
	SUT_ASSERT_EQUALS(Int,check_plus(e),25);
	SUT_ASSERT_EQUALS(Int,check_plus(f),0);

	SUT_ASSERT_EQUALS(Int,check_minus(a),100);
	SUT_ASSERT_EQUALS(Int,check_minus(b),10);
	SUT_ASSERT_EQUALS(Int,check_minus(c),0);
	SUT_ASSERT_EQUALS(Int,check_minus(d),10);
	SUT_ASSERT_EQUALS(Int,check_minus(e),25);
	SUT_ASSERT_EQUALS(Int,check_minus(f),0);

	a.setMin(0);
	b.setMax(110);
	c.setVal(5);
	d.set(0,40);
	e.set(20,20);
	f.set(1,21,1);

	flow_(checkstate<byte>(a,true ,false,false,0,100,0));
	flow_(checkstate<byte>(b,true ,false,false,10,110,10));
	flow_(checkstate<byte>(c,true ,true ,true ,30,30,30));
	flow_(checkstate<byte>(d,false,false,false,0,40,10));
	flow_(checkstate<byte>(e,false,true ,false,20,25,25));
	flow_(checkstate<byte>(f,true ,false,false,1,21,1));

	flow_(checkprogress<byte>(a,  0,100,  0,100,0.0,1.0,0.0f,1.0f));
	flow_(checkprogress<byte>(b,  0,100,  0,100,0.0,1.0,0.0f,1.0f));
	flow_(checkprogress<byte>(c,  0,  0,  0,  0,0.0,0.0,0.0f,0.0f));
	flow_(checkprogress<byte>(d, 10, 30, 25, 75,0.25,0.75,0.25f,0.75f));
	flow_(checkprogress<byte>(e,  5,  0,100,  0,1.0,0.0,1.0f,0.0f));
	flow_(checkprogress<byte>(f,  0, 20,  0,100,0.0,1.0,0.0f,1.0f));

	a += 255;SUT_ASSERT_EQUALS(Int,a,100);
	b += 212;SUT_ASSERT_EQUALS(Int,b,110);
	c += 243;SUT_ASSERT_EQUALS(Int,c,30);

}
void tr_u(){
	URange a;
	URange b(10,20);
	URange c(30,20);
	URange d(10,20,15);
	URange e(100,50,25);
	URange f(1,1,1);

	flow_(checkstate<uint>(a,true ,false,false,0,100,0));
	flow_(checkstate<uint>(b,true ,false,false,10,20,10));
	flow_(checkstate<uint>(c,true ,true ,true ,30,30,30));
	flow_(checkstate<uint>(d,false,false,false,10,20,15));
	flow_(checkstate<uint>(e,true ,false,false,25,50,25));
	flow_(checkstate<uint>(f,true ,true ,true ,1,1,1));

	SUT_ASSERT_EQUALS(Int,check_plus(a),100);
	SUT_ASSERT_EQUALS(Int,check_plus(b),10);
	SUT_ASSERT_EQUALS(Int,check_plus(c),0);
	SUT_ASSERT_EQUALS(Int,check_plus(d),5);
	SUT_ASSERT_EQUALS(Int,check_plus(e),25);
	SUT_ASSERT_EQUALS(Int,check_plus(f),0);

	SUT_ASSERT_EQUALS(Int,check_minus(a),100);
	SUT_ASSERT_EQUALS(Int,check_minus(b),10);
	SUT_ASSERT_EQUALS(Int,check_minus(c),0);
	SUT_ASSERT_EQUALS(Int,check_minus(d),10);
	SUT_ASSERT_EQUALS(Int,check_minus(e),25);
	SUT_ASSERT_EQUALS(Int,check_minus(f),0);

	a.setMin(0);
	b.setMax(110);
	c.setVal(5);
	d.set(0,40);
	e.set(20,20);
	f.set(1,21,1);

	flow_(checkstate<uint>(a,true ,false,false,0,100,0));
	flow_(checkstate<uint>(b,true ,false,false,10,110,10));
	flow_(checkstate<uint>(c,true ,true ,true ,30,30,30));
	flow_(checkstate<uint>(d,false,false,false,0,40,10));
	flow_(checkstate<uint>(e,false,true ,false,20,25,25));
	flow_(checkstate<uint>(f,true ,false,false,1,21,1));

	flow_(checkprogress<uint>(a,  0,100,  0,100,0.0,1.0,0.0f,1.0f));
	flow_(checkprogress<uint>(b,  0,100,  0,100,0.0,1.0,0.0f,1.0f));
	flow_(checkprogress<uint>(c,  0,  0,  0,  0,0.0,0.0,0.0f,0.0f));
	flow_(checkprogress<uint>(d, 10, 30, 25, 75,0.25,0.75,0.25f,0.75f));
	flow_(checkprogress<uint>(e,  5,  0,100,  0,1.0,0.0,1.0f,0.0f));
	flow_(checkprogress<uint>(f,  0, 20,  0,100,0.0,1.0,0.0f,1.0f));

	a += 1255;SUT_ASSERT_EQUALS(Int,a,100);
	b += 1212;SUT_ASSERT_EQUALS(Int,b,110);
	c += 1243;SUT_ASSERT_EQUALS(Int,c,30);

}

void test_Range(){
	tr_c();
	tr_b();
	tr_u();
}