#include "stdafx.h"
#include "test_funcs.h"
#include <scpl/allocater.h>

using namespace scpl;

void test_allocater(){
	HAlloc ha;
	VAlloc va;

	SUT_CHECK_EQUALS(Ptr,ha.getData(),NULL);
	SUT_CHECK_EQUALS(Int,ha.getSize(),0);
	SUT_CHECK_EQUALS(Ptr,va.getData(),NULL);
	SUT_CHECK_EQUALS(Int,va.getSize(),0);

	SUT_ASSERT(ha.init(128));
	SUT_ASSERT(va.commit(128));

	SUT_CHECK_EQUALS(Ptr,ha.getData(),NULL);
	SUT_CHECK_EQUALS(Int,ha.getSize(),0);
	SUT_CHECK_NOTEQUALS(Ptr,va.getData(),NULL);
	SUT_CHECK_EQUALS(Int,va.getSize(),128);

	SUT_ASSERT(ha.allocate(128));

	SUT_CHECK_NOTEQUALS(Ptr,ha.getData(),NULL);
	SUT_CHECK_EQUALS(Int,ha.getSize(),128);
}