#include "stdafx.h"
#include "test_funcs.h"
#include <scpl/copy.h>

using namespace scpl;

static byte B1[3] = {1,10,100};
static byte B2[3][3] = {
	{1,10,100},
	{10,100,1},
	{100,1,10}
};
static byte B3[3][3][3] = {
	{
		{1,10,100},{1,10,101},{1,11,111}},{
		{100,1,10},{101,1,10},{111,1,11}},{
		{10,100,1},{10,101,1},{11,111,1}
	}
};

static ulong L1[3] = {0x00000000L,0x0f0f0f0fL,0xffffffffL};
static ulong L2[3][3] = {
	{0x12300000L,0x01230000L,0x00012300L},
	{0x00001230L,0x00000123L,0x30000012L},
	{0x23000001L,0x10203000L,0x10020030L}
};
static ulong L3[3][3][3] = {
	{
		{0x000000ffL,0xffffffffL,0xff000000L},
		{0x0000ffffL,0x00000000L,0xffff0000L},
		{0x00ffff00L,0x000ff000L,0x00ffff00L}},{
		{0xffff0000L,0x00ffff00L,0x00ffffffL},
		{0xff0000ffL,0xff0000ffL,0xff0000ffL},
		{0xffff0000L,0x00ffff00L,0x00ffffffL}},{
		{0x00ffff00L,0x000ff000L,0x00ffff00L},
		{0x0000ffffL,0xf0f00f0fL,0xffff0000L},
		{0xff0000ffL,0xffffffffL,0xff0000ffL}
	}
};

template <class T,ulong C>
void check(const T(&a)[C],const T(&b)[C]){
	for(ulong i=0;i<C;++i){
		SUT_ASSERT_EQUALS(Hex,a[i],b[i]);
	}
}
template <class T,ulong C1,ulong C2>
void check(const T(&a)[C1][C2],const T(&b)[C1][C2]){
	for(ulong i=0;i<C1;++i){
		for(ulong j=0;j<C2;++j){
			SUT_ASSERT_EQUALS(Hex,a[i][j],b[i][j]);
		}
	}
}
template <class T,ulong C1,ulong C2,ulong C3>
void check(const T(&a)[C1][C2][C3],const T(&b)[C1][C2][C3]){
	for(ulong i=0;i<C1;++i){
		for(ulong j=0;j<C2;++j){
			for(ulong l=0;l<C3;++l){
				SUT_ASSERT_EQUALS(Hex,a[i][j][l],b[i][j][l]);
			}
		}
	}
}

template <class T> void _copy(T& dest,const T& src){
	memcpy(dest,src,sizeof(T));
}

void test_copy(){
	byte b1[3];
	byte b2[3][3];
	byte b3[3][3][3];
	ulong l1[3];
	ulong l2[3][3];
	ulong l3[3][3][3];

	_copy(b1,B1);check(b1,B1);
	_copy(b2,B2);check(b2,B2);
	_copy(b3,B3);check(b3,B3);

	_copy(l1,L1);check(l1,L1);
	_copy(l2,L2);check(l2,L2);
	_copy(l3,L3);check(l3,L3);
}