/* * * Sdg_Yacc.y * * *
 * ʸϴؿ
 * * * * * * * * * * */
%{

#include"Sdg_Error.h"
#include"Sdg_Script.h"
#include<iostream>
using namespace std;

#define YY_parse_PARSE Sdg_Parser::yyparse

void yyerror(const char *msg);

%}

%union{
	int num;
}

%token <num> NUMBER
%left '+' '-'
%left '*' '/'
%right UMINUS
%type <num> expr

%%

file:   /*null*/
	| file line
	;

line:	expr '\n' { cout << "result=" << $1 << endl;}
	| '\n'
	;

expr:	expr '+' expr { $$ = $1 + $3;}
	| expr '-' expr { $$ = $1 - $3;}
	| expr '*' expr { $$ = $1 * $3;}
	| expr '/' expr { $$ = $1 / $3;}
	| '(' expr ')' { $$ = $2;}
	| NUMBER { $$ = $1;}
	| '-' expr %prec UMINUS {$$ = -$2;}
	;
%%

void yyerror(const char *msg)
{
	fputs(msg,stderr);
	putc('\n',stderr);
}
