/* * * Sdg_Variable.h * * *
 * ѿ
 * * * * * * * * * * * * * * */
#ifndef _SDG_VARIABLE_H_
#define _SDG_VARIABLE_H_

#include"Sdg_Base.h"
#include <string>

enum Sdg_Variable_Type{
	NO_DATA,
	NUMBER,
	STRING,
	VAR_LIST,
};

typedef double Sdg_Number;
typedef std::string Sdg_String;

/*----- ѿ -----*/
class Sdg_Variable : public Sdg_Base{
 public:
	Sdg_Variable():Sdg_Base("Sdg_Variable"),type(NO_DATA){}
	Sdg_Variable(const Sdg_Number num):Sdg_Base("Sdg_Variable"),type(NUMBER),_num(num){}
	Sdg_Variable(const Sdg_String &str):Sdg_Base("Sdg_Variable"),type(STRING){_str = new Sdg_String(str);}
	~Sdg_Variable(){}

	/*ǡ*/
	const Sdg_Variable_Type Type(void) const {return type;} 
	const Sdg_String &String(void) const {return *_str;}
	const Sdg_Number Number(void) const {return _num;}

	/**/
	Sdg_Variable &operator=(const Sdg_Variable &data);
	Sdg_Variable &operator=(const Sdg_String &str);
	Sdg_Variable &operator=(const Sdg_Number num);

 private:
	Sdg_Variable_Type type;
	union{
		Sdg_Number _num;
		Sdg_String *_str;
	};
};

/*§黻*/
Sdg_Variable operator+(const Sdg_Variable &v1,const Sdg_Variable &v2);
Sdg_Variable operator-(const Sdg_Variable &v1,const Sdg_Variable &v2);
Sdg_Variable operator*(const Sdg_Variable &v1,const Sdg_Variable &v2);
Sdg_Variable operator/(const Sdg_Variable &v1,const Sdg_Variable &v2);

/*ɽ*/
std::ostream &operator<<(std::ostream &os,const Sdg_Variable &v);

/*------ ѿ ------*/
/*ڤΥǡ*/
struct _Sdg_Tree{
	const Sdg_String name;
	Sdg_Variable var;
	_Sdg_Tree *left;
	_Sdg_Tree *right;

	_Sdg_Tree(const Sdg_String &n,Sdg_Variable &v):name(n),var(v),left(NULL),right(NULL){}
};
/*饹*/
class Sdg_List : public Sdg_Base{
 public:
	Sdg_List();
	~Sdg_List();

	/*ؿ*/
	//ɲ
	void Add(const Sdg_String &v_name,Sdg_Variable &v);
	//(դʤNULL)
	Sdg_Variable *Search(const Sdg_String &v_name);
 private:
	_Sdg_Tree *root;
};

#endif
