/*
 * Decompiled with CFR 0.152.
 */
package jp.thaniwa.scriptdirector;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.AbstractList;
import java.util.Iterator;
import jp.thaniwa.scriptdirector.ScriptDirectorInterface;
import jp.thaniwa.scriptdirector.modules.DataFile;
import jp.thaniwa.scriptdirector.modules.Scenario;
import jp.thaniwa.scriptdirector.modules.Scene;
import jp.thaniwa.scriptdirector.utils.ScenarioExecutor;
import jp.thaniwa.scriptdirector.utils.ScenarioReader;

public class ScriptDirector
implements ScriptDirectorInterface,
Runnable {
    private Scenario scenario;
    private FileWriter logWriter;
    private FileWriter csvWriter;
    private String separator = System.getProperty("line.separator");
    private ScriptDirectorInterface scriptDirectorInterface = this;
    private boolean getIntVal4csv = false;
    private boolean dataFileChecker = true;

    public ScriptDirector(ScriptDirectorInterface sInterface, String scenarioName, String log, String csv, boolean intval) {
        this.scriptDirectorInterface = sInterface;
        this.initialize(scenarioName, log, csv, intval);
    }

    public ScriptDirector(String scenarioName, String log, String csv, boolean intval) {
        this.initialize(scenarioName, log, csv, intval);
    }

    private void initialize(String scenarioName, String log, String csv, boolean intval) {
        this.fileSetup(scenarioName, log, csv);
        this.scenario = ScenarioReader.read(scenarioName);
        this.getIntVal4csv = intval;
        this.printDataFileInfo(this.scenario);
        this.printScenarioStepInfo(this.scenario);
    }

    public void setScriptDirectorInterface(ScriptDirectorInterface scriptDirectorInterface) {
        this.scriptDirectorInterface = scriptDirectorInterface;
    }

    private void fileSetup(String scenario, String log, String csv) {
        this.logWriter = this.getFileWriter(log);
        this.csvWriter = this.getFileWriter(csv);
        this.printString("");
        this.printString("===== \u30d5\u30a1\u30a4\u30eb\u60c5\u5831 =====");
        File scenarioFile = new File(scenario);
        if (scenarioFile.canRead()) {
            this.printString("scenario\u30d5\u30a1\u30a4\u30eb : " + scenarioFile.getAbsolutePath());
        } else {
            this.printString("scenario\u30d5\u30a1\u30a4\u30eb\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3002 : " + scenarioFile.getAbsolutePath());
            ScriptDirector.usage();
        }
        if (this.logWriter != null) {
            File logFile = new File(log);
            this.printString("log\u30d5\u30a1\u30a4\u30eb : " + logFile.getAbsolutePath());
        }
        if (this.csvWriter != null) {
            File csvFile = new File(csv);
            this.printString("csv\u30d5\u30a1\u30a4\u30eb : " + csvFile.getAbsolutePath());
        }
    }

    public int getAllStepNumber() {
        int result = 0;
        if (this.scenario != null) {
            result = this.scenario.getAllStepNumer();
        }
        return result;
    }

    private void printDataFileInfo(Scenario scenario) {
        this.printString("");
        this.printString("===== \u30c7\u30fc\u30bf\u30d5\u30a1\u30a4\u30eb\u60c5\u5831 =====");
        AbstractList<DataFile> list = scenario.getDataFileList();
        if (list != null) {
            for (DataFile dataFile : list) {
                this.printString(dataFile.getDataFileInfo());
                if (dataFile.getDataList() != null) continue;
                this.printString("*** \u30c7\u30fc\u30bf\u30d5\u30a1\u30a4\u30eb\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3002");
                this.printString("*** \u30b7\u30ca\u30ea\u30aa\u30d5\u30a1\u30a4\u30eb\u3092\u898b\u76f4\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
                this.printString("*** \u30b7\u30ca\u30ea\u30aa\u306f\u5b9f\u884c\u3057\u307e\u305b\u3093\u3002");
                this.dataFileChecker = false;
            }
        }
    }

    private void printScenarioStepInfo(Scenario scenario) {
        this.printString("");
        this.printString("===== \u30b7\u30ca\u30ea\u30aa\u60c5\u5831 =====");
        this.printString("\u30b7\u30ca\u30ea\u30aa\u7dcf\u30b9\u30c6\u30c3\u30d7\u6570 : " + scenario.getAllStepNumer());
    }

    @Override
    public void run() {
        ScenarioExecutor sExecutor = new ScenarioExecutor(this.scenario);
        int result = 0;
        if (!this.dataFileChecker) {
            this.exit(99);
        }
        this.printString("");
        this.printString("====== \u30b7\u30ca\u30ea\u30aa\u5b9f\u884c\u3092\u958b\u59cb\u3057\u307e\u3059\u3002 =====");
        this.printString("");
        while ((result = sExecutor.executeNext()) != -1) {
            this.scriptDirectorInterface.updateExecuteInformation(sExecutor.getExecutedComment(), sExecutor.getExecutedLine());
            this.output(sExecutor);
            Scene.Type type = sExecutor.getAfterExecuteAction(result);
            while (type == Scene.Type.Retry) {
                this.printString("");
                this.printString("===== \u5b9f\u884c\u3092\u505c\u6b62\u3057\u307e\u3059\u3002\u30ad\u30fc\u5165\u529b\u5f8c\u3001\u518d\u5b9f\u884c\u3057\u307e\u3059\u3002 =====");
                this.pause();
                type = sExecutor.getAfterExecuteAction(result);
            }
            sExecutor.setResult(result);
            if (type == Scene.Type.Pause) {
                this.scriptDirectorInterface.pause();
                continue;
            }
            if (type != Scene.Type.Stop) continue;
            this.printString("");
            this.printString("====== \u30b7\u30ca\u30ea\u30aa\u5b9f\u884c\u3092\u4e2d\u65ad\u3057\u307e\u3059\u3002 =====");
            this.printString("");
            this.exitScriptDirector(sExecutor, 1, this.getIntVal4csv);
        }
        this.printString("");
        this.printString("====== \u30b7\u30ca\u30ea\u30aa\u5b9f\u884c\u3092\u5b8c\u4e86\u3057\u307e\u3057\u305f\u3002 =====");
        this.printString("");
        this.exitScriptDirector(sExecutor, 0, this.getIntVal4csv);
    }

    private void exitScriptDirector(ScenarioExecutor sExecutor, int exitNumber, boolean intval) {
        AbstractList<String> list = sExecutor.getResultCSV(intval);
        this.printString("");
        this.printString("===== Result : csv =====");
        this.printString("");
        if (list != null) {
            for (String string : list) {
                this.printString(string);
                if (this.csvWriter == null) continue;
                try {
                    this.csvWriter.write(string + this.separator);
                }
                catch (IOException ioe) {}
            }
        }
        try {
            if (this.logWriter != null) {
                this.logWriter.close();
            }
            if (this.csvWriter != null) {
                this.csvWriter.close();
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        this.scriptDirectorInterface.exit(exitNumber);
    }

    @Override
    public void exit(int exitNumber) {
        System.exit(exitNumber);
    }

    @Override
    public void println(String string) {
        System.out.println(string);
    }

    private void printString(String string) {
        this.scriptDirectorInterface.println(string);
        try {
            if (this.logWriter != null) {
                this.logWriter.write(string + this.separator);
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    @Override
    public void updateExecuteInformation(String overview, String command) {
    }

    private void output(ScenarioExecutor sExecutor) {
        Iterator<String> i;
        this.printString("");
        this.printString("\u5b9f\u884c\u6982\u8981 : " + sExecutor.getExecutedComment());
        this.printString("\u5b9f\u884c\u30b3\u30de\u30f3\u30c9 : " + sExecutor.getExecutedLine());
        this.printString("");
        AbstractList<String> list = sExecutor.getStdOut();
        if (list != null) {
            i = list.iterator();
            while (i.hasNext()) {
                this.printString(i.next());
            }
        }
        if ((list = sExecutor.getStdErr()) != null) {
            i = list.iterator();
            while (i.hasNext()) {
                this.printString(i.next());
            }
        }
        this.printString("");
    }

    @Override
    public void pause() {
        try {
            this.printString("");
            this.printString("===== Press Return Key =====");
            BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
            reader.readLine();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    private FileWriter getFileWriter(String string) {
        FileWriter fileWriter = null;
        if (string != null && string.length() > 0) {
            try {
                fileWriter = new FileWriter(string, true);
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
        return fileWriter;
    }

    public static void main(String[] args) {
        String scenario = null;
        String log = null;
        String csv = null;
        boolean scenario_checker = false;
        boolean log_checker = false;
        boolean csv_checker = false;
        boolean intval_checker = false;
        if (args != null && args.length > 1) {
            for (int i = 0; i < args.length; ++i) {
                if (scenario_checker) {
                    scenario = args[i];
                    scenario_checker = false;
                    continue;
                }
                if (log_checker) {
                    log = args[i];
                    log_checker = false;
                    continue;
                }
                if (csv_checker) {
                    csv = args[i];
                    csv_checker = false;
                    continue;
                }
                if (args[i].equals("-scenario")) {
                    scenario_checker = true;
                    continue;
                }
                if (args[i].equals("-log")) {
                    log_checker = true;
                    continue;
                }
                if (args[i].equals("-csv")) {
                    csv_checker = true;
                    continue;
                }
                if (!args[i].equals("-intval")) continue;
                intval_checker = true;
            }
        } else {
            ScriptDirector.usage();
        }
        if (scenario_checker || scenario == null) {
            System.out.println("\u30b7\u30ca\u30ea\u30aa\u30d5\u30a1\u30a4\u30eb\u304c\u5b9a\u7fa9\u3055\u308c\u3066\u307e\u305b\u3093\u3002");
            ScriptDirector.usage();
        } else if (log_checker) {
            System.out.println("\u30ed\u30b0\u30d5\u30a1\u30a4\u30eb\u304c\u5b9a\u7fa9\u304c\u4e0d\u6b63\u3067\u3059\u3002");
            ScriptDirector.usage();
        } else if (csv_checker) {
            System.out.println("csv\u30d5\u30a1\u30a4\u30eb\u304c\u5b9a\u7fa9\u304c\u4e0d\u6b63\u3067\u3059\u3002");
            ScriptDirector.usage();
        }
        ScriptDirector scriptDirector = new ScriptDirector(scenario, log, csv, intval_checker);
        scriptDirector.run();
    }

    private static void usage() {
        System.out.println("");
        System.out.println("Usage > java -cp ScriptDirector.jar jp.thaniwa.scriptdirector.ScriptDirector -scenario [scenario] <options>");
        System.out.println("");
        System.out.println("  Required Argument  ");
        System.out.println("    -scenario [scenario] ... set scenario file for ScriptDirector / required");
        System.out.println("  Options  ");
        System.out.println("    -log [Log File] ... set log file to output execution data, default is not set.");
        System.out.println("    -csv [csv File] ... set csv file to output results, default is standard out.");
        System.out.println("    -intval         ... set csv data to use int return value. default output uses o, x, -");
        System.out.println("");
        System.exit(99);
    }
}

