#!/bin/bash -f
#
# ユーザーアカウントロック設定スクリプト
#
# Developed by Yasuhiro Fujitsuki 2010/3
#
# 返り値：
# 0 = 成功
# 1 = 失敗
# 9 = ユーザー作成を実行せず
# 99 = Usage 表示/オプション設定ミス
#

###################################
# 返り値定義 / 条件を変える場合、この部分を変更する
SUCCESS=0
FAILED=1
PASSED=9
USAGE=99
###################################
# 環境変数
# 実行ファイル
GREP=/bin/grep
WC=/usr/bin/wc 
WC_L="${WC} -l"
USERMOD=/usr/sbin/usermod
PASSWD=/usr/bin/passwd

# コンフィグファイル 
ETC_PASSWD=/etc/passwd
###################################


# 引数確認
# 引数が指定数無い場合は usage 表示を行い、終了
if [ $# -ne 2 ]; then
  echo 引数指定がされていません。
  echo 
  echo usage \> $0 [User Name] [Lock]
  echo
  echo "[User Name] ... ユーザーアカウント"
  echo "[Lock]      ... パスワードロックフラグ"
  echo "                0=パスワードロックを解除"
  echo "                1=パスワードロックを実施"
  exit $USAGE
fi

# 引数の読み込み
USER_NAME=$1
LOCK=$2


# ユーザーの存在確認
if [ `${GREP} ^${USER_NAME}: $ETC_PASSWD | ${WC_L} ` -eq 0 ]; then
  echo \#\#\# ユーザー ${USER_NAME} が存在しません。
  exit $PASSED
fi

# アカウント有効設定(1=有効,0=無効(ロック))

if [ $LOCK = "1" ]; then
  echo \# $USERMOD -L $USER_NAME
  $USERMOD -L $USER_NAME
else
  CHECK_LOCK=`$PASSWD -S $USER_NAME | grep locked | wc -l`
  if [ $CHECK_LOCK = "1" ]; then
    echo \# $USERMOD -U $USER_NAME
    $USERMOD -U $USER_NAME
  fi
fi

echo \# $PASSWD -S $USER_NAME 
$PASSWD -S $USER_NAME

exit $SUCCESS
