#!/bin/bash -f
#
# グループ作成、確認用スクリプト
#
# Developed by Yasuhiro Fujitsuki 2010/3
#
# 返り値：
# 0 = 成功
# 1 = 失敗
# 9 = ユーザー作成を実行せず
# 99 = Usage 表示/オプション設定ミス
#

###################################
# 返り値定義 / 条件を変える場合、この部分を変更する
SUCCESS=0
FAILED=1
PASSED=9
USAGE=99
###################################
# 環境変数
# 実行ファイル
GROUPADD=/usr/sbin/groupadd
GREP=/bin/grep
WC=/usr/bin/wc 
WC_L="${WC} -l"
SED="/bin/sed"
# 設定ファイル
ETC_PASSWD=/etc/passwd
ETC_GROUP=/etc/group
###################################

echo

# 引数確認
# 引数が指定数無い場合は usage 表示を行い、終了

USAGE_CHECK=0

# 引数の数
if [ $# -ne 2 ]; then
  USAGE_CHECK=1
  echo 引数指定がされていません。
  echo 
fi

# 引数の読み込み
GROUP_NAME=$1
GROUP_ID=$2

# 第2引数が数値かどうかの確認
A=`echo -n $GROUP_ID | sed 's/[0-9]//g' `
if [ -n "$A" ]; then
  USAGE_CHECK=1
  echo 第2引数に文字列が含まれています。
  echo
fi

if [ $USAGE_CHECK -ne 0 ]; then
  echo usage \> $0 [Group Name] [Group ID]
  echo
  echo "[Group Name]   ... グループ名 "
  echo "[Group ID] ... グループ番号"
  echo
  echo
  echo "*注意* グループ名が重複する場合は PASSED 扱い"
  echo "       グループIDが重複する場合は FAILED 扱い"
  exit $USAGE
fi

# グループの存在確認
echo \#\#\# グループの存在確認を行います。
echo
echo  \# ${GREP} ^${GROUP_NAME}: ${ETC_GROUP}
${GREP} ^${GROUP_NAME}: ${ETC_GROUP}
echo

if [ `${GREP} ^${GROUP_NAME}: ${ETC_GROUP} | ${WC_L} ` -ne 0 ]; then
  echo \#\#\# グループ ${GROUP_NAME} が既に存在します。
  echo \#\#\# グループの追加処理は行いません。
  exit $PASSED
fi

# グループIDの存在確認
echo \#\#\# グループIDの確認を行います。
echo
echo  \# ${GREP} :${GROUP_ID}: ${ETC_GROUP}
${GREP} :${GROUP_ID}: ${ETC_GROUP}
echo

if [ `${GREP} :${GROUP_ID}: ${ETC_GROUP} | ${WC_L} ` -ne 0 ]; then
  echo \#\#\# グループID ${GROUP_ID} は既に利用中です。
  echo \#\#\# グループの追加処理は行いません。
  exit $FAILED
fi

# グループの追加作業
echo \#\#\# グループの追加を行います。
echo \#\#\#   グループ名 : ${GROUP_NAME}
echo \#\#\#   グループID : ${GROUP_ID}
echo
echo  \# ${GROUPADD} -g ${GROUP_ID} ${GROUP_NAME}

${GROUPADD} -g ${GROUP_ID} ${GROUP_NAME}

# コマンド成功確認

RESULT=$?

if [ $RESULT -ne $SUCCESS ]; then
  echo \#\#\# グループの作成に失敗しました。
  echo \#\#\# Error Code : $RESULT
  exit $FAILED
fi

echo 
echo \#\#\# グループが作成されたことを確認します。
echo 
echo  \# ${GREP} ^${GROUP_NAME}: ${ETC_GROUP}

${GREP} ^${GROUP_NAME}: ${ETC_GROUP}

exit $SUCCESS

