#!/bin/bash
################################
# ユーザー一括削除スクリプト
#   Created by Yasuhiro Fujitsuki(thaniwa) 2010/3
################################

################################
# ユーザーデータファイルの定義
USER_FILE="data/user_list_linux.csv"
GROUP_FILE="data/group_list_linux.csv"
################################


IFS=$'\n'

echo
echo ユーザーの削除
echo

# ユーザー情報の読み込み 
for LINE in `cat $USER_FILE`
do

  #######################################
  # ユーザー情報の抽出 
  #######################################

  USER_NAME=`echo $LINE | cut -d "," -f 1`

  #######################################
  # ユーザー削除
  #######################################

  echo \# userdel -rf $USER_NAME
  userdel -rf $USER_NAME

done

echo
echo グループの削除
echo

# グループ情報の読み込み
for LINE in `cat $GROUP_FILE`
do

  #######################################
  # グループ名の抽出 
  #######################################

  GROUP_NAME=`echo $LINE | cut -d "," -f 1`

  #######################################
  # ユーザー削除
  #######################################

  echo \# groupdel $GROUP_NAME
  groupdel $GROUP_NAME

done

echo
echo
echo ユーザーの削除を終了しました。
echo
echo

