﻿using System;

namespace Framework
{
    /// <summary>
    /// 通常のArgExceptionのビルダが実装すべきインターフェイスです。
    /// </summary>
    public interface IArgExceptionBuilder
    {
        /// <summary>
        /// しかし、引数nameはvalでした。
        /// </summary>
        ArgException but(string name, object val);
    }

    sealed class ExpectedBetweenBuilder : IArgExceptionBuilder
    {
        readonly object from, to;
        internal ExpectedBetweenBuilder(object from, object to)
        {
            this.from = from;
            this.to = to;
        }

        public ArgException but(string name, object val)
        {
            return new ArgException(name, val, ExpectedType.FromTo, from, to);
        }
    }

    sealed class ExpectedAnyBuilder : IArgExceptionBuilder
    {
        readonly object[] expecteds;
        internal ExpectedAnyBuilder(params object[] expecteds)
        {
            this.expecteds = expecteds;
        }

        public ArgException but(string name, object val)
        {
            return new ArgException(name, val, ExpectedType.Any, expecteds);
        }
    }

    sealed class ExpectedThresholdBuilder : IArgExceptionBuilder
    {
        readonly ExpectedType type;
        readonly string thresholdVarName;
        readonly IComparable threshold;
        internal ExpectedThresholdBuilder(ExpectedType type, IComparable threshold)
        {
            this.type = type;
            this.thresholdVarName = null;
            this.threshold = threshold;
        }
        internal ExpectedThresholdBuilder(ExpectedType type, string name, IComparable threshold)
        {
            this.type = type;
            this.thresholdVarName = name;
            this.threshold = threshold;
        }

        public ArgException but(string name, object val)
        {
            return new ArgException(name, val, type, thresholdVarName, threshold);
        }
    }

    /// <summary>
    /// 特殊なビルダです。
    /// </summary>
    public interface IUnexpectedNullBuilder
    {
        /// <summary>
        /// しかし、引数はnullでした。
        /// </summary>
        ArgException butArgIsNull(string name);
    }

    sealed class UnexpectedNullBuilder : IUnexpectedNullBuilder
    {
        public ArgException butArgIsNull(string name)
        {
            return new ArgException(name, null, ExpectedType.NotNull);
        }
    }

    sealed class UnexpectedBuilder : IArgExceptionBuilder
    {
        readonly object unexpected;
        internal UnexpectedBuilder(object unexpected)
        {
            this.unexpected = unexpected;
        }

        public ArgException but(string name, object val)
        {
            return new ArgException(name, val, ExpectedType.Unexpected, unexpected);
        }
    }

    sealed class UnexpectedEqBuilder : IArgExceptionBuilder
    {
        readonly string unexpectedName;
        internal UnexpectedEqBuilder(string unexpectedName)
        {
            this.unexpectedName = unexpectedName;
        }

        public ArgException but(string name, object val)
        {
            return new ArgException(name, val, ExpectedType.UnexpectedEq, unexpectedName as object);
        }
    }

    sealed class ExpectedFormatBuilder : IArgExceptionBuilder
    {
        readonly string format;
        internal ExpectedFormatBuilder(string format)
        {
            this.format = format;
        }

        public ArgException but(string name, object val)
        {
            return new ArgException(name, val, ExpectedType.Format, format);
        }
    }
}
