﻿using System;

namespace Framework
{
    /// <summary>
    /// int の拡張メソッドです。
    /// </summary>
    public static class IntExtension
    {
        public static TimeSpan Ms(this int target)
        {
            return TimeSpan.FromMilliseconds(target);
        }

        public static TimeSpan Second(this int target)
        {
            return TimeSpan.FromSeconds(target);
        }

        public static TimeSpan Seconds(this int target)
        {
            return TimeSpan.FromSeconds(target);
        }

        public static TimeSpan Minute(this int target)
        {
            return TimeSpan.FromMinutes(target);
        }

        public static TimeSpan Minutes(this int target)
        {
            return TimeSpan.FromMinutes(target);
        }

        public static TimeSpan Hour(this int target)
        {
            return TimeSpan.FromHours(target);
        }

        public static TimeSpan Hours(this int target)
        {
            return TimeSpan.FromHours(target);
        }

        public static TimeSpan Day(this int target)
        {
            return TimeSpan.FromDays(target);
        }

        public static TimeSpan Days(this int target)
        {
            return TimeSpan.FromDays(target);
        }

        public static TimeSpan Week(this int target)
        {
            return TimeSpan.FromDays(target * 7);
        }

        public static TimeSpan Weeks(this int target)
        {
            return TimeSpan.FromDays(target * 7);
        }

        public static string Px(this int target)
        {
            return target + "px";
        }

        public static string Percent(this int target)
        {
            return target + "%";
        }

        /// <summary>
        /// act を target回 呼び出します。
        /// </summary>
        /// <example>
        /// 5.Times(() => Console.Write("A")); とするとコンソールに "AAAAA"が出力できます（Aを5回出力）
        /// </example>
        /// <param name="target">呼び出し回数</param>
        /// <param name="act">呼び出される処理</param>
        public static void Times(this int target, Action act)
        {
            for (int i = 0; i < target; i++)
            {
                act();
            }
        }

        /// <summary>
        /// act を target回 呼び出します。Actionの引数intは0から始まり呼び出されるごとに１づつ増える数値です。
        /// </summary>
        /// <example>
        /// 5.Times((i) => Console.Write(i)); とするとコンソールに "01234"が出力できます。
        /// </example>
        /// <param name="target">呼び出し回数</param>
        /// <param name="act">呼び出される処理</param>
        public static void Times(this int target, Action<int> act)
        {
            for (int i = 0; i < target; i++)
            {
                act(i);
            }
        }

        /// <summary>
        /// Convert.ToByte(target) を返します。
        /// </summary>
        /// <param name="target"></param>
        /// <returns></returns>
        public static byte ToByte(this int target)
        {
            return Convert.ToByte(target);
        }

        /// <summary>
        /// target の d乗 を返します。
        /// </summary>
        /// <param name="target"></param>
        /// <param name="d">乗数</param>
        /// <returns></returns>
        public static double Pow(this int target, double d)
        {
            return Math.Pow(target, d);
        }

        /// <summary>
        /// targetとcompareの大きいほうを返します。
        /// </summary>
        /// <param name="target"></param>
        /// <param name="compare"></param>
        /// <returns></returns>
        public static int Max(this int target, int compare)
        {
            return target > compare ? target : compare;
        }

        /// <summary>
        /// targetとcompareの小さいほうを返します。
        /// </summary>
        /// <param name="target"></param>
        /// <param name="compare"></param>
        /// <returns></returns>
        public static int Min(this int target, int compare)
        {
            return target < compare ? target : compare;
        }

    }
}
