﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Framework
{
    /// <summary>
    /// 基数を表す列挙
    /// </summary>
    public enum Radix : int
    {
        Bin = 2, Oct = 8, Deci = 10, Hex = 16
    }

    /// <summary>
    /// Radix の 拡張メソッドです。
    /// </summary>
    internal static class RadixExtension
    {
        internal static string ToFormat(this Radix r)
        {
            return string.Format("{0} digit number", (int)r);
        }
    }
}
