﻿
namespace Framework.Web.UI.CompositeControls
{
    /// <summary>
    /// GridViewPagerのRowDeletingイベントのイベント引数
    /// </summary>
    public class GridViewPagerDeleteEventArgs : System.EventArgs
    {
        /// <summary>
        /// イベントをキャンセルする場合はtrueをセットします
        /// </summary>
        public bool Cancel = false;

        /// <summary>
        /// 更新行のDataKey
        /// </summary>
        public System.Web.UI.WebControls.DataKey DataKey;

        /// <summary>
        /// 更新行の行オブジェクト
        /// </summary>
        public System.Web.UI.WebControls.GridViewRow GridViewRow;

        /// <summary>
        /// 更新行の行インデックス
        /// </summary>
        public int RowIndex = -1;

        /// <summary>
        /// 更新行の行タイプ。フッター行で追加の場合はDataControlRowType.Footerになります。
        /// </summary>
        public System.Web.UI.WebControls.DataControlRowType RowType;
    }

    /// <summary>
    /// GridViewPagerのRowDeletingイベント
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    public delegate void GridViewPagerDeleteEventHandler(object sender, GridViewPagerDeleteEventArgs e);
}
