﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

using System.ComponentModel;
using System.Web.UI;
using System.Web.UI.WebControls;

using Framework;

namespace Framework.Web.UI
{
    /// <summary>
    /// CheckBoxFieldの機能拡張版
    /// </summary>
    public class LCheckBoxField : System.Web.UI.WebControls.CheckBoxField
    {
        /// <summary>
        /// マッピング名。未指定の場合はDataFieldと同じ
        /// </summary>
        [Category("Custom")]
        [DefaultValue("")]
        public string MappingName
        {
            get { return _mappingName.IsEmpty() ? base.DataField : _mappingName; }
            set { _mappingName = value; }
        }
        private string _mappingName;

        /// <summary>
        /// ヘッダに表示するテキストのテキストキー
        /// </summary>
        /// 
        public string HeaderLTextKey { get; set; }

        /// <summary>
        /// データ値がこの値と等しい場合に、チェック有りにする。また編集時にはチェックありの場合はこの値を返す。
        /// </summary>
        public string CheckedValue { get; set; }

        /// <summary>
        /// 編集時にチェックなしの場合はこの値を返す。
        /// </summary>
        public string UncheckedValue { get; set; }

        /// <summary>
        /// 親GridViewの参照を返します。
        /// </summary>
        private LGridView Parent
        {
            get { return this.Control as LGridView; }
        }

        /// <summary>
        /// Initialize
        /// </summary>
        /// <param name="enableSorting"></param>
        /// <param name="control"></param>
        /// <returns></returns>
        public override bool Initialize(bool enableSorting, System.Web.UI.Control control)
        {
            //ローカライズ
            if (this.HeaderLTextKey.IsNotEmpty())
            {
                base.HeaderText = LTextMgr.GetText(this.HeaderLTextKey);
            }

            return base.Initialize(enableSorting, control);
        }

        /// <summary>
        /// InitializeCell
        /// </summary>
        /// <param name="cell"></param>
        /// <param name="cellType"></param>
        /// <param name="rowState"></param>
        /// <param name="rowIndex"></param>
        public override void InitializeCell(DataControlFieldCell cell, DataControlCellType cellType, DataControlRowState rowState, int rowIndex)
        {
            if ((cellType == DataControlCellType.DataCell && (rowState & DataControlRowState.Edit) != 0)
                || (cellType == DataControlCellType.Footer && this.Parent.ShowInsertFooter))
            {
                //編集行、または行追加用フッターの場合

                var chk = new MCheckBox()
                {
                    MappingName = this.MappingName,
                    CheckedValue = this.CheckedValue,
                    UncheckedValue = this.UncheckedValue
                };

                cell.Controls.Add(chk);
            }
            else
            {
                base.InitializeCell(cell, cellType, rowState, rowIndex);
            }
        }

        /// <summary>
        /// GetValue の override
        /// </summary>
        /// <param name="controlContainer"></param>
        /// <returns></returns>
        protected override object GetValue(Control controlContainer)
        {
            var val = base.GetValue(controlContainer);

            if (this.CheckedValue.IsNotEmpty())
            {
                //CheckedValueが指定されている場合は、バインド値がCheckedValueと同じならtrueを返す（チェックありにする）。

                if (val != null && val.ToString() == this.CheckedValue)
                {
                    val = true;
                }
                else
                {
                    val = false;
                }
            }

            return val;
        }
    }
}
