﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Framework.Web.UI
{
    /// <summary>
    /// 言語選択DDL
    /// </summary>
    public class LangDropDownList : Framework.Web.UI.MDropDownList
    {
        public string CLASS_NAME ;

        /// <summary>
        /// 選択変更後にページの再表示を行うかどうか
        /// </summary>
        public bool AllowPageRefresh { get; set; }

        /// <summary>
        /// コンストラクタ
        /// </summary>
        public LangDropDownList()
        {
            CLASS_NAME = this.GetType().FullName;

            this.ListKey = CLASS_NAME;
            base.AutoPostBack = true;
            this.AllowPageRefresh = false;
        }

        /// <summary>
        /// OnSelectedIndexChanged
        /// </summary>
        /// <param name="e"></param>
        protected override void OnSelectedIndexChanged(EventArgs e)
        {
            if (base.AutoPostBack == true)
            {
                Lang.Current = this.SelectedValue;
            }

            //OnSelectedIndexChanged
            base.OnSelectedIndexChanged(e);

            if (this.AllowPageRefresh == true)
            {
                this.Page.Response.Redirect(this.Page.Request.Url.PathAndQuery);
            }
        }
    }
}
