﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.ComponentModel;

namespace Framework.Web.UI
{
    /// <summary>
    /// 画面遷移用のリンクボタン。PageNavとセットで使用します。
    /// </summary>
    public class PageNavLink : LLinkButton
    {
        /// <summary>
        /// コンストラクタ
        /// </summary>
        public PageNavLink()
        {
            this.TargetPageNav = "PageNav";
            this.PageNavMethod = UI.PageNavMethod.Redirect;
        }

        /// <summary>
        /// 画面遷移に使用するメソッドを指定します。
        /// </summary>
        public PageNavMethod PageNavMethod { get; set; }

        /// <summary>
        /// 同じページ内のPageNavのIDをセットします。デフォルトは"PageNav"です。
        /// </summary>
        public string TargetPageNav { get; set; }

        /// <summary>
        /// 画面遷移先のURLを指定します。
        /// </summary>
        public string NavigateUrl { get; set; }

        /// <summary>
        /// OnClick
        /// </summary>
        /// <param name="e"></param>
        protected override void OnClick(EventArgs e)
        {
            //OnClick
            base.OnClick(e);

            //画面遷移
            var target = (PageNav)this.FindControl(this.TargetPageNav);
            target.Navigate(this.PageNavMethod, this.NavigateUrl, true);
        }
    }
}
