﻿using System;
using System.ComponentModel;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Web.UI;
using System.Web.UI.WebControls;

namespace Framework.Web.UI
{
    /// <summary>
    /// クリック時にポップ画面を開くボタン
    /// </summary>
    public class PopupButton : System.Web.UI.WebControls.Button, ILocalizeControl
    {
        /// <summary>
        /// ポップアップするウィンドウの幅
        /// </summary>
        public int WindowWidth 
        { 
            get {return _windowWidth;}
            set { _windowWidth = value; } 
        }
        private int _windowWidth = 0;

        /// <summary>
        /// ポップアップするウィンドウの幅
        /// </summary>
        public int WindowHeight
        {
            get { return _windowHeight; }
            set { _windowHeight = value; }
        }
        private int _windowHeight = 0;

        /// <summary>
        /// ポップアップするウィンドウのURL
        /// </summary>
        public string WindowUrl { get; set; }

        /// <summary>
        /// ポップアップするウィンドウの名前。デフォルトは_blank
        /// </summary>
        public string WindowName 
        {
            get { return _windowName; }
            set { _windowName = value; }
        }
        private string _windowName = "_blank";

        /// <summary>
        /// ポップアップするウィンドウのキャッシュを無効にするか。
        /// </summary>
        public bool WindowNoCache
        {
            get { return _windowNoCache; }
            set { _windowNoCache = value; }
        }
        private bool _windowNoCache = true;

        /// <summary>
        /// ポップアップするウィンドウにスクロールバーをつけるか。
        /// </summary>
        public bool WindowScrollbars
        {
            get { return _windowScrollbars; }
            set { _windowScrollbars = value; }
        }
        private bool _windowScrollbars = false;


        /// <summary>
        /// 指定した場合はURLの末尾にbtnid={指定したコントロールのClientID}を付与します。
        /// 呼び出し先の画面から呼び出し元のボタンをクリックする場合などに使用します。
        /// </summary>
        public string CallbackControl { get; set; }

        /// <summary>
        /// 画面をオープンする前のイベント。これを指定した場合は、ボタンクリック時にポストバックが発生します。
        /// </summary>
        public event CancelEventHandler BeforePopup;


        /// <summary>
        /// テキストのローカライズキー
        /// </summary>
        [Category("Custom")]
        [DefaultValue("")]
        public string LTextKey { get; set; }

        /// <summary>
        /// コンストラクタ
        /// </summary>
        public PopupButton()
        {
            //「ENTER」キーによるSubmitを無効にさせるための処理
            base.UseSubmitBehavior = false;
        }

        /// <summary>
        /// OnInit
        /// </summary>
        /// <param name="e"></param>
        protected override void OnInit(EventArgs e)
        {
            if (this.BeforePopup != null)
            {
                //クリックイベントを登録する
                this.Click += new EventHandler(PopupButton_Click);
            }

            base.OnInit(e);
        }

        /// <summary>
        /// OnPreRender
        /// </summary>
        /// <param name="e"></param>
        protected override void OnPreRender(EventArgs e)
        {
            if (this.BeforePopup == null)
            {
                //ポップアップのスクリプト登録
                this.RegisterScript(this);
            }

            base.OnPreRender(e);
        }

        /// <summary>
        /// 自ボタンのクリックイベント
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        void PopupButton_Click(object sender, EventArgs e)
        {
            //ポップアップ前イベントを呼び出す
            var ce = new CancelEventArgs();
            this.BeforePopup(this, ce);

            if (ce.Cancel == true)
            {
                return;
            }

            //画面をポップアップさせるためのスクリプトを登録する。
            this.RegisterScript(this.Page);
        }

        /// <summary>
        /// 画面をポップアップさせるためのスクリプト登録を登録する。
        /// </summary>
        /// <param name="c"></param>
        public void RegisterScript(Control c)
        {
            var ws = new WindowStyle();
            ws.NoCache = this.WindowNoCache;
            ws.Scrollbars = this.WindowScrollbars;
            if (this.WindowWidth > 0) ws.Width = this.WindowWidth;
            if (this.WindowHeight > 0) ws.Height = this.WindowHeight;

            var url = this.WindowUrl;
            if (this.CallbackControl.IsNotEmpty())
            {
                var id = ((Control)this.NamingContainer.FindControl(this.CallbackControl)).ClientID;
                url = url + ((url.IndexOf("?") < 0) ? "?" : "&");
                url = url + string.Format("btnid={0}", id);
            }

            JavaScript.RegisterWindowOpen(c, url, this.WindowName, ws);
        }


        #region ILocalizeControl メンバ

        public void Localize(System.Globalization.CultureInfo lang)
        {
            if (this.LTextKey.IsNotEmpty())
            {
                base.Text = LTextMgr.GetText(lang, this.LTextKey);
            }
        }

        #endregion
    }
}
