﻿using System;
using System.Collections.Generic;
using System.Data;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

using Framework.Data;
using Framework.Web;
using Framework.Web.UI;

namespace Sample1.Master
{
    public partial class LText : System.Web.UI.Page
    {
        /// <summary>
        /// 検索条件を保持します
        /// </summary>
        private MappingData SearchData
        {
            get { return SessionMgr.Load<MappingData>(this, "SearchData", null); }
            set { SessionMgr.Save(this, "SearchData", value); }
        }

        /// <summary>
        /// Page_Load
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        protected void Page_Load(object sender, EventArgs e)
        {
            if (this.Page.IsPostBack == false)
            {
                //画面初期化
                UIController.ListSrcDataBind(this);         //リストのデータバインド
                this.ddlLang.DefaultValue = Lang.Current.ToString();
                UIController.SetMappingData(this, null);   //初期値でマッピング

                //デフォルト条件で検索実行
                this.btnSearch_Click(null, null);

                //ローカライズ
                UIController.Localize(this);
            }
        }

        /// <summary>
        /// 言語DDLのSelectedIndexChanged
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        protected void ddlLang_SelectedIndexChanged(object sender, EventArgs e)
        {
            //言語切り替え
            Lang.Current = this.ddlLang.SelectedValue;

            //ページ初期化
            SessionMgr.Remove(this);
            Response.Redirect(Request.Url.PathAndQuery);
        }


        /// <summary>
        /// 検索ボタンクリック
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        protected void btnSearch_Click(object sender, System.EventArgs e)
        {
            //入力値検証

            //検索条件の入力値を取得し、Sessionに保持
            var data = UIController.GetMappingData(this.pnlSearch);
            this.SearchData = data;

            //検索実行
            this.gvpList.GridViewDataBind(true);
        }

        /// <summary>
        /// GridViewのデータソースリクエストイベント
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        protected void gvpList_GridViewSrcRequest(object sender, Framework.Web.UI.CompositeControls.GridViewSrcRequestEventArgs e)
        {
            new LTextDb().ReqestGridViewSrc(e, this.SearchData);
        }

        /// <summary>
        /// GridViewのRowCommandイベント
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        protected void gvpList_RowCommand(object sender, Framework.Web.UI.CompositeControls.GridViewPagerCommandEventArgs e)
        {
            if (e.CommandName == "Add")
            {
                //追加の場合

                //検証
                if (UIController.ValidateInput(e.GridViewRow) == false)
                {
                    this.lblMsg.Text = LTextMgr.GetText("MsgInvalid");
                    return;
                }

                //データ追加
                var data = UIController.GetMappingData(e.GridViewRow);
                if (new LTextDb().Insert(data) == 0)
                {
                    this.lblMsg.Text = LTextMgr.GetText("MsgExists");
                }
                else
                {
                    //キャッシュクリア
                    LTextMgr.ClearCache();

                    //再検索
                    this.gvpList.GridViewDataBind(false);

                    this.lblMsg.Text = LTextMgr.GetText("MsgAdded");
                }
            }
            else if (e.CommandName == "Clear")
            {
                //クリアの場合

                UIController.ClearInput(e.GridViewRow);
            }
        }

        /// <summary>
        /// GridViewのRowUpdatingイベント
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        protected void gvpList_RowUpdating(object sender, Framework.Web.UI.CompositeControls.GridViewPagerUpdateEventArgs e)
        {
            //入力値の検証

            //データ更新
            var data = UIController.GetMappingData(e.GridViewRow);
            if (new LTextDb().Update(e, data) == 0)
            {
                //更新済みの場合

                e.Cancel = true;
                this.lblMsg.Text = LTextMgr.GetText("MsgUpdatedByOther");
            }
            else
            {
                this.lblMsg.Text = LTextMgr.GetText("MsgUpdated");
            }
        }

        /// <summary>
        /// GridViewのRowDeletingイベント
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        protected void gvpList_RowDeleting(object sender, Framework.Web.UI.CompositeControls.GridViewPagerDeleteEventArgs e)
        {
            //削除
            var data = UIController.GetMappingData(e.GridViewRow);
            if (new LTextDb().Delete(data) == 0)
            {
                //更新済みの場合

                e.Cancel = true;
                this.lblMsg.Text = LTextMgr.GetText("MsgUpdatedByOther");
            }
            else
            {
                this.lblMsg.Text = LTextMgr.GetText("MsgDeleted");
            }
        }
    }

}