﻿using System;
using System.Collections.Generic;
using System.Data;
using System.Linq;

using Framework;
using Framework.Data;
using Framework.Web.UI.CompositeControls;
using Framework.DB.SqlServerCe;

namespace Sample1.Master
{
    public class LTextDb : DbAccessBase
    {
        /// <summary>
        /// tblに全件をFillします。
        /// </summary>
        /// <param name="tbl"></param>
        public void FillData(Framework.Data.LTextSrcDataSet ds)
        {
            var sql = @"
                SELECT 'ja' as LangId
                     , LTEXT_KEY as LTextKey
                     , LTEXT_JPN as Text
                  FROM TM_LTEXT
                UNION ALL
                SELECT 'en' as LangId
                     , LTEXT_KEY as LTextKey
                     , LTEXT_ENG as Text
                  FROM TM_LTEXT
                ";

            base.FillDataTable(ds.LTextSrc, sql);
        }

        /// <summary>
        /// データソースリクエスト
        /// </summary>
        /// <param name="e"></param>
        /// <param name="data"></param>
        public void ReqestGridViewSrc(GridViewSrcRequestEventArgs e, MappingData data)
        {
            var select = @"
                |SELECT LTEXT_KEY
                |     , LTEXT_JPN
                |     , LTEXT_ENG
                |     , CONVERT(bigint, ROW_VER) ROW_VER
                ".StripMargin();

            var where = @"
                |  FROM TM_LTEXT
                | WHERE 1 = 1
                ".StripMargin();

            if (data["PK"].IsNotBlank() == true)
            {
                where += " AND LTEXT_KEY = @PK";
            }
            if (data["LTEXT_KEY"].IsNotBlank() == true)
            {
                where += " AND LTEXT_KEY LIKE '%' + @LTEXT_KEY + '%'";
            }


            //総件数の取得
            string sqlCnt = "SELECT COUNT(*) " + where;
            e.TotalRecords = (int)base.ExecuteScalar(sqlCnt, data);

            //データ取得
            var sql = @"
                |{0}
                |{1}
                |ORDER BY {2}
                |OFFSET {3} ROWS
                |FETCH NEXT {4} ROWS ONLY
                ".StripMargin()
                 .Fmt(select, where, e.SortExpression, e.StartRecord - 1, e.MaxRecords);
            e.DataSource = base.GetDataTable(sql, data).DefaultView;
        }

        /// <summary>
        /// Update
        /// </summary>
        /// <param name="data"></param>
        /// <returns>更新件数</returns>
        public int Update(GridViewPagerUpdateEventArgs e, Framework.Data.MappingData data)
        {
            var sql = @"
                |UPDATE TM_LTEXT
                |   SET LTEXT_JPN = @LTEXT_JPN
                |     , LTEXT_ENG = @LTEXT_ENG
                | WHERE LTEXT_KEY = @LTEXT_KEY
                |   AND CONVERT(bigint, ROW_VER) = CONVERT(bigint, @ROW_VER)
                ".StripMargin();

            var cnt = 0;
            base.ExecuteTransaction(() =>
            {
                //更新
                cnt = base.ExecuteNonQuery(sql, data);

                if (cnt > 0)
                {
                    //更新後のデータ取得
                    var re = new GridViewSrcRequestEventArgs(1, 1, "LTEXT_KEY");
                    this.ReqestGridViewSrc(re, new MappingData("PK", data["LTEXT_KEY"]));
                    e.NewValues = re.DataSource[0];
                }
            });

            return cnt;
        }

        /// <summary>
        /// Insert
        /// </summary>
        /// <param name="data"></param>
        public int Insert(MappingData data)
        {
            var sqlChk = @"
                |SELECT COUNT(*)
                |  FROM TM_LTEXT
                | WHERE LTEXT_KEY = @LTEXT_KEY
                ".StripMargin();

            var sql = @"
                |INSERT INTO TM_LTEXT
                |     ( LTEXT_KEY
                |     , LTEXT_JPN
                |     , LTEXT_ENG )
                |VALUES
                |     ( @LTEXT_KEY
                |     , @LTEXT_JPN
                |     , @LTEXT_ENG)
                ".StripMargin();

            var cnt = 0;
            base.ExecuteTransaction(() =>
            {
                if ((int)base.ExecuteScalar(sqlChk, data) == 0)
                {
                    cnt = base.ExecuteNonQuery(sql, data);
                }
            });

            return cnt;
        }


        /// <summary>
        /// Delete
        /// </summary>
        /// <param name="data"></param>
        /// <returns>削除件数</returns>
        public int Delete(MappingData data)
        {
            var sql = @"
                |DELETE FROM TM_LTEXT
                | WHERE LTEXT_KEY = @LTEXT_KEY
                |   AND CONVERT(bigint, ROW_VER) = CONVERT(bigint, @ROW_VER)
                ".StripMargin();

            var cnt = 0;
            base.ExecuteTransaction(() =>
            {
                cnt = base.ExecuteNonQuery(sql, data);
            });

            return cnt;
        }

    }
}