#include "sdl4gcj/video/Screen.h"
#include "sdl4gcj/video/VideoInfo.h"
#include "sdl4gcj/video/Rect.h"
#include "sdl4gcj/SDLException.h"

#include <stdlib.h>
#include <gcj/cni.h>
#include <SDL.h>


using namespace sdl4gcj::video;

static
inline
sdl4gcj::SDLException*
createIllegalStateScreenException()
{
	return new sdl4gcj::SDLException(JvNewStringLatin1("This Screen has Illegal state."));
}

// class methods
Screen* 
Screen::setVideoMode (jint width, jint height, jint bpp, jint flags)
{
	JvInitClass(&Screen::class$);
	Screen* result = NULL;

	SDL_Surface* screen = SDL_SetVideoMode(width, height, bpp, flags);
	if (screen != NULL)
		result = Screen::getVideoSurface();
	return result;
}

Screen* 
Screen::getVideoSurface ()
{
	JvInitClass(&Screen::class$);
	SDL_Surface* screen = SDL_GetVideoSurface();

	if (screen != NULL)
	{
		if (singleton == NULL || ((SDL_Surface*)singleton->implementation) != screen)
		{
			singleton = new Screen();
			singleton->implementation = (::gnu::gcj::RawData*)screen;
		}
	}
	return singleton;
}

VideoInfo* 
Screen::getVideoInfo ()
{
	JvInitClass(&Screen::class$);
	VideoInfo* videoInfo = NULL;
	const SDL_VideoInfo* native = NULL;

	native = SDL_GetVideoInfo();
	videoInfo = new VideoInfo();
	videoInfo->implementation = (::gnu::gcj::RawData*)native;

	return videoInfo;
}

void 
Screen::setGamma (jfloat redgamma, jfloat greengamma, jfloat bluegamma)
{
	JvInitClass(&Screen::class$);

	int result = SDL_SetGamma(redgamma, greengamma, bluegamma);
	if (result == -1) throw new SDLException();

	return ;
}


void 
Screen::setGammaRamp (jintArray redArray, jintArray greenArray, jintArray blueArray)
{
	JvInitClass(&Screen::class$);

	Uint16* arguments[3] = {NULL, NULL, NULL};
	Uint16 nativeRamp[3][256];
	jintArray ramp[3];
	ramp[0] = redArray;
	ramp[1] = greenArray;
	ramp[2] = blueArray;

	for (int i = 0;i < 3;i++)
	{
		if (ramp[i] != NULL)
		{
			jint* a = elements(ramp[i]);
			int length = JvGetArrayLength(ramp[i]);
			if (length > 256) length = 256;
			for (int j = 0;j < 256;j++) nativeRamp[i][j] = 0;
			for (int j = 0;j < length;j++) nativeRamp[i][j] = a[j];
			arguments[i] = nativeRamp[i];
		}
	}

	int result = SDL_SetGammaRamp(arguments[0], 
		arguments[1], arguments[2]);
	if (result == -1) throw new SDLException();

	return ;
}


jintArray 
Screen::getRedGammaRamp ()
{
	JvInitClass(&Screen::class$);

	Uint16 redTable[256];
	SDL_GetGammaRamp(redTable, NULL, NULL);

	jintArray gammaRampArray = JvNewIntArray(256);
	jint* gammaRamp = elements(gammaRampArray);
	for (int i = 0;i < 256;i++)
		gammaRamp[i] = (jint)redTable[i];

	return gammaRampArray;
}

jintArray
Screen::getGreenGammaRamp ()
{
	JvInitClass(&Screen::class$);

	Uint16 greenTable[256];
	SDL_GetGammaRamp(NULL, greenTable, NULL);

	jintArray gammaRampArray = JvNewIntArray(256);
	jint* gammaRamp = elements(gammaRampArray);
	for (int i = 0;i < 256;i++)
		gammaRamp[i] = (jint)greenTable[i];

	return gammaRampArray;
}

jintArray
Screen::getBlueGammaRamp ()
{
	JvInitClass(&Screen::class$);

	Uint16 blueTable[256];
	SDL_GetGammaRamp(NULL, NULL, blueTable);

	jintArray gammaRampArray = JvNewIntArray(256);
	jint* gammaRamp = elements(gammaRampArray);
	for (int i = 0;i < 256;i++)
		gammaRamp[i] = (jint)blueTable[i];

	return gammaRampArray;
}


// instance methods

void 
Screen::updateRect (jint x, jint y, jint w, jint h)
{
	if (this->implementation == NULL) throw createIllegalStateScreenException();
	SDL_Surface* nativeScreen = (SDL_Surface*)this->implementation;

	SDL_UpdateRect(nativeScreen, x, y, w, h);
}


void 
Screen::updateRects (JArray< ::sdl4gcj::video::Rect *> *rectArray)
{
	if (this->implementation == NULL) throw createIllegalStateScreenException();
	SDL_Surface* nativeScreen = (SDL_Surface*)this->implementation;

	int length = JvGetArrayLength(rectArray);
	Rect** rects = elements(rectArray);
	SDL_Rect nativeRects[length];

	for (int i = length-1;i >= 0;i--)
	{
		if (rects[i] != NULL)
		{
			nativeRects[i].x = rects[i]->getX();
			nativeRects[i].y = rects[i]->getY();
			nativeRects[i].w = rects[i]->getW();
			nativeRects[i].h = rects[i]->getH();
		}
		else
		{
			nativeRects[i].x = 0;
			nativeRects[i].y = 0;
			nativeRects[i].w = 0;
			nativeRects[i].h = 0;
		}
	}

	SDL_UpdateRects(nativeScreen, length, nativeRects);
}

void 
Screen::flip()
{
	if (this->implementation == NULL) throw createIllegalStateScreenException();
	SDL_Surface* nativeScreen = (SDL_Surface*)this->implementation;

	int result = SDL_Flip(nativeScreen);
	if (result == -1) new SDLException();
}


