import sdl4gcj.Sys;
import sdl4gcj.video.*;
import sdl4gcj.event.*;
import sdl4gcj.input.*;

public class PixelsTest
{

	public static void main(String[] args)
	{
		if (Sys.init(Sys.SDL_INIT_VIDEO) != 0)
		{
			System.out.println("init fail.");
			System.exit(0);
		}

		Screen screen = Screen.setVideoMode(256, 256, 8, Surface.SDL_SWSURFACE);

		// make and set palette (grayscale)
		Color[] colors = new Color[256];
		for (int i = 0;i < colors.length;i++) 
			colors[i] = new Color(i, i, i);
		screen.setPalette(colors);

		// edit pixels (gradation)
		byte[] pixels = screen.getPixels();
		int width = screen.getW();
		int height = screen.getH();
		int pitch = screen.getPitch();
		for (int y = 0;y < height;y++)
		{
			for (int x = 0;x < width;x++) 
			{
				pixels[y * pitch + x] = (byte)y;
			}
		}
		screen.setPixels(pixels);

		System.gc();
		screen.flip();

		boolean done = false;
		EventManager event = new EventManager();
		while (!done)
		{
			event.waitEvent();
			switch (event.type)
			{
				case SDLEvent.SDL_KEYDOWN :
					if (event.keydown.sym == Keyboard.SDLK_ESCAPE ||
						event.keydown.sym == Keyboard.SDLK_q)
						done = true;
					break;
				case SDLEvent.SDL_QUIT:
					done = true;
					break;
				default:
					break;
			}
		}

		Sys.quit();
	}
}
