package sdl4gcj;

public class Version
{
	private int major;
	private int minor;
	private int patch;
	private String versionString = null;

	public Version(int major, int minor, int patch)
	{
		this.major = major;
		this.minor = minor;
		this.patch = patch;
	}

	public int getMajor() { return this.major; }
	public int getMinor() { return this.minor; }
	public int getPatch() { return this.patch; }

	public boolean equals(Object obj)
	{
		return (obj instanceof Version ) && 
			(this.major == ((Version)obj).major) &&
			(this.minor == ((Version)obj).minor) &&
			(this.patch == ((Version)obj).patch);
	}

	public int hashCode ()
	{
		return this.major * 100 + this.minor * 10 + this.patch;
	}

	public String toString ()
	{
		if (versionString == null)
			versionString = this.major + "." +this.minor + "." + this.patch;
		return versionString;
	}
}
