package sdl4gcj.video;

public class Palette
{
	public static int DEFAULT_SIZE = 0xff;

	/**
	* SDL_Color colors[size]
	**/
	protected gnu.gcj.RawData colors = null;

	/**
	* size of palette table
	**/
	private int size;

	public Palette()
	{
		this(DEFAULT_SIZE);
	}

	public Palette(int size)
	{
		this.initializePalette(size);
	}

	public Palette(Color[] colors)
	{
		this(colors.length);
		this.setColors(colors);
	}

	public int getSize() { return size; }

	public native Color getColorAt(int index);

	public void setColorAt(int index, Color color)
	{
		this.setColorAt(index, color.r, color.g, color.b);
	}

	public native void setColorAt(int index, int r, int g, int b);

	public Color[] getColors()
	{
		Color[] colors = new Color[this.getSize()];
		for (int i = this.getSize()-1;i >= 0;i--)
			colors[i] = getColorAt(i);
		return colors;
	}

	public void setColors(Color[] colors)
	{
		int count = this.getSize();
		if (colors.length < count) count = colors.length;

		for (int i = count-1;i >= 0;i--)
			setColorAt(i, colors[i]);
	}

	public String toString()
	{
		StringBuffer buffer = new StringBuffer(super.toString());
		int size = this.getSize();
		for (int i = 0;i < size;i++)
		{
			buffer.append("color[");
			buffer.append(i);
			buffer.append("] = ");
			buffer.append(this.getColorAt(i));
			buffer.append("\n");
		}
		return buffer.toString();
	}

	protected native void initializePalette(int size);
	protected native void finalizePalette();
}
