import java.util.Random;
import sdl4gcj.*;
import sdl4gcj.video.*;
import sdl4gcj.event.*;
import sdl4gcj.input.*;

public class ImageFontTest implements SDLConstants
{
	static final String message = "Hello, World!!";

	public static void main(String[] args)
	{
		if (Sys.init(SDL_INIT_VIDEO) != 0)
		{
			System.out.println("Sys#init() fail.");
			System.exit(0);
		}
		

		SDLOptionParser optParser = new SDLOptionParser(
			640, 480, 8, 
			Surface.SDL_SWSURFACE|Surface.SDL_ANYFORMAT);
		optParser.parse(args);

		Screen screen = Screen.setVideoMode(
			optParser.getScreenWidth(), optParser.getScreenHeight(),
			optParser.getBitsPerPixel(),
			optParser.getVideoFlags());

		ImageFont font = new ImageFont();
		font.getFontSurface().displayFormat();

		int bgPixel = screen.mapRGB(Color.BLUE);
		screen.fillRect(bgPixel);

		int width = message.length() * font.getWidth();
		int height = font.getHeight();
		int movableW = screen.getW() - width;
		int movableH = screen.getH() - height;

		font.draw(screen, message, movableW/2, movableH/2);
		screen.flip();
		System.gc();

		EventManager event = new EventManager();
		boolean done = false;
		while (!done)
		{
			while (event.pollEvent() > 0)
			{
				switch (event.type)
				{
					case SDL_MOUSEBUTTONDOWN:
						if (event.buttondown.button == 1)
						{
							font.draw(screen, message, 
								event.buttondown.x - width/2, 
								event.buttondown.y - height/2);
						}
						else
						{
							screen.fillRect(bgPixel);
						}
						screen.flip();
						break;
					case SDL_KEYDOWN :
						if ((event.keydown.sym == Keyboard.SDLK_ESCAPE) ||
							(event.keydown.sym == Keyboard.SDLK_q))
						{
							done = true;
						}
						break;
					case SDL_QUIT:
						done = true;
						break;
					default:
						break;
				}
			}
		}

		Sys.quit();
	}
}
