/************************************************************
Copyright (C) 2005 Masahiko SAWAI All Rights Reserved. 
************************************************************/
package sdl4gcj.event;

public class JoyAxisEvent extends SDLEvent
{
	public short which;	/* The joystick device index */
	public short axis;	/* The joystick axis index */
	public int value;	/* The axis value (range: -32768 to 32767) */

	public JoyAxisEvent()
	{
		this((short)0, (short)0, (short)0);
	}
	public JoyAxisEvent(short which, short axis, int value)
	{
		super(SDL_JOYAXISMOTION);
		this.which = which;
		this.axis = axis;
		this.value = value;
	}

	public String toString()
	{
		return super.toString() + 
			"{" +
			"which : " + this.which + 
			", axis : " + this.axis + 
			", value : " + this.value +
			"}";
	}
}
