/************************************************************
Copyright (C) 2005 Masahiko SAWAI All Rights Reserved. 
************************************************************/
package sdl4gcj.event;

import sdl4gcj.input.KeyboardConstants;

public class KeyboardEvent extends SDLEvent implements KeyboardConstants
{
	public short which;	/* The keyboard device index */
	public short state;	/* SDL_PRESSED or SDL_RELEASED */
	public short scancode;
	public int sym;
	public int mod;
	public char unicode;

	protected KeyboardEvent(int type, short which , short state, short scancode, int sym, int mod, char unicode)
	{
		super(type);
		this.which = which;
		this.state = state;
		this.scancode = scancode;
		this.sym = sym;
		this.mod = mod;
		this.unicode = unicode;
	}


	public String toString()
	{
		return super.toString() + 
			"{" +
			", type : " + this.type + 
			", which : " + this.which + 
			", state : " + this.state + 
			", scancode : " + scancode + 
			", sym : " + sym + 
			", mod : " + mod + 
			", unicode : " + unicode +
			"}";
	}
}
