/************************************************************
Copyright (C) 2005 Masahiko SAWAI All Rights Reserved. 
************************************************************/
#include "sdl4gcj/image/Image.h"

#include "sdl4gcj/video/Surface.h"
#include "sdl4gcj/SDLException.h"

#include <gcj/cni.h>
#include <java/lang/String.h>
#include <stdlib.h>
#include <SDL.h>
#include <SDL_image.h>


using namespace sdl4gcj::image;
using sdl4gcj::video::Surface;

// function

static
inline
sdl4gcj::SDLException*
createImageLoadFailException()
{
	return new sdl4gcj::SDLException(JvNewStringLatin1(IMG_GetError()));
}

// class methods

Surface *
Image::load(::java::lang::String* filePath)
{
	JvInitClass(&Image::class$);
	Surface* image = NULL;

	jbyteArray byteArray = filePath->getBytes();
	int length = JvGetArrayLength(byteArray);
	jbyte* bytes = elements(byteArray);
	char buffer[length+1];

	memcpy(buffer, bytes, length);
	buffer[length] = '\0';

	SDL_Surface* nativeImage = IMG_Load(buffer);
	if (nativeImage == NULL) throw createImageLoadFailException();

	image = new Surface();
	image->implementation = (::gnu::gcj::RawData*)nativeImage;

	return image;
}

Surface *
Image::load(JArray<jbyte>* byteArray, jint offset, jint length)
{
	JvInitClass(&Image::class$);
	Surface* image = NULL;
	jbyte* bytes = elements(byteArray) + offset;

	SDL_Surface* nativeImage = IMG_Load_RW(SDL_RWFromMem(bytes, length), 1);
	if (nativeImage == NULL) throw createImageLoadFailException();

	image = new Surface();
	image->implementation = (::gnu::gcj::RawData*)nativeImage;

	return image;
}

