/************************************************************
Copyright (C) 2005 Masahiko SAWAI All Rights Reserved. 
************************************************************/
package sdl4gcj.ttf;

import sdl4gcj.Version;

/** \package  sdl4gcj.ttf
* TrueType font renderer. This is a SDL_ttf wrapper.
**/

public class TTFSystem implements FontConstants
{
	// instance variables
	protected gnu.gcj.RawData implementation = null;

	// class methods 
	/**
	* Get version of compiled library.
	* @return The version of compiled library 
	**/
	public static native Version compiledVersion();

	/**
	* Get version of linked library .
	* @return The version of linked library
	**/
	public static native Version linkedVersion();

	/**
	* Initialize TTF subsystem.
	* If the TTF subsystem was initialized, SDLException occur.
	**/
	public static native void init();
		
	/**
	* Check TTF subsystem was already initialized.
	* @return <code>true</code> if the TTF subsystem was initialized,
	*         <code>false</code> otherwise.
	**/
	public static native boolean wasInit();
		
	/**
	* Finalize TTF subsystem.
	* @return <code>0</code> if the TTF subsystem was initialized.
	**/
	public static native void quit();
}
