import sdl4gcj.SDLSystem;
import sdl4gcj.SDLConstants;
import sdl4gcj.video.*;
import sdl4gcj.event.*;
import sdl4gcj.input.Mouse;

public class RepeatTest implements SDLConstants
{
	static final String BG_IMAGE_PATH = "images/logo.bmp";
	static final String ICON_IMAGE_PATH = "images/icon.bmp";

	public static void main(String[] args)
	{
		SDLSystem.init(SDL_INIT_VIDEO);
		try
		{
			Screen screen = Screen.setVideoMode(640, 480, 32, 
				SDL_SWSURFACE);

			// load background image
			Surface bgTip = Surface.loadBMP(BG_IMAGE_PATH);
			Surface bg = Surface.createRGBSurface(SDL_SWSURFACE, 640, 480, 32, 0xff0000, 0xff00, 0xff, 0x00);
			bg.repeatSurface(bgTip);
			bg.displayFormat();

			Surface icon = Surface.loadBMP(ICON_IMAGE_PATH);
			icon.setColorKey(SDL_SRCCOLORKEY|SDL_RLEACCEL);
			icon.displayFormat();

			screen.blitSurface(bg);
			screen.updateRect();

			boolean done = false;
			EventManager event = new EventManager();
			while (!done)
			{
				event.waitEvent();
				switch (event.type)
				{
					case SDL_MOUSEMOTION :
						if (Mouse.getMouse().getButtonState(SDL_BUTTON_LEFT))
						{
							screen.blitSurface(icon, event.motion.x, event.motion.y);
							screen.updateRect();
						}
						break;
					case SDL_MOUSEBUTTONUP :
						if (event.buttonup.button == SDL_BUTTON_RIGHT)
						{
							screen.blitSurface(bg);
							screen.updateRect();
						}
						break;
					case SDL_KEYDOWN :
						if ((event.keydown.sym == SDLK_ESCAPE) ||
							(event.keydown.sym == SDLK_q))
							done = true;
						break;
					case SDL_QUIT:
						done = true;
						break;
					default:
						break;
				}
			}
		}
		catch (Exception e)
		{
			e.printStackTrace();
		}
		finally
		{
			SDLSystem.quit();
		}
	}
}
