
#include <stdio.h>
#include <string.h>

#include "SDL_archive.h"
#include "SDL.h"


void PrintIndent(int nest)
{
	int i;
	
	for (i = 0; i < nest; i++) {
		if (i < nest - 1) {
			printf(" ");
		} else {
			printf("+");
		}
	}
}


int ListDirectory(SDL_Archive *arc, int nest, int isSize)
{
	int i;
	int result;
	
	for (i = 0; i < Archive_GetChildDirNum(arc); i++) {
		printf("d:");
		PrintIndent(nest + 1);
		printf(
			"%s(%s)\n",
			Archive_GetChildDirName(arc, i),
			Archive_GetCurrentDirPath(arc));
		result = Archive_GoDownDir(
			arc, Archive_GetChildDirName(arc, i));
		if (result != ARCHIVE_SUCCESS) {
			printf(
				"!ERROR: %s ... Archive_GoDownDir is failed\n",
				Archive_GetChildDirName(arc, i));
		}
		if (result == ARCHIVE_SUCCESS) {
			ListDirectory(arc, nest + 1, isSize);
			Archive_GoUpDir(arc);
		}
	}
	for (i = 0; i < Archive_GetFileNum(arc); i++) {
		printf("f:");
		PrintIndent(nest + 1);
		printf(
			"%s(%s)",
			Archive_GetFileName(arc, i),
			Archive_GetCurrentDirPath(arc));
		if (isSize) {
			result = Archive_Open(arc, Archive_GetFileName(arc, i));
			if (result == ARCHIVE_SUCCESS) {
				printf(" %d byte", Archive_Size(arc));
				Archive_Close(arc);
			} else {
				printf(" file open error");
			}
		}
		printf("\n");
	}
	
	return 0;
}


void ShowUsage(const char *thisName)
{
	printf("Usage: %s [-size] [-gzfilter] [-clone] archive\n", thisName);
}


int main(int argc, char *argv[])
{
	ArchiverList *archiverList;
	SDL_Archive *arc;
	SDL_Archive *orgArc;
	int i;
	int openArgvNum;
	int isSize;
	int isGZFilter;
	int isClone;
	
	if (argc == 1) {
		ShowUsage(argv[0]);
		return 0;
	}
	
	SDL_Init(SDL_INIT_VIDEO | SDL_INIT_AUDIO);
	
	isSize = SDL_FALSE;
	isGZFilter = SDL_FALSE;
	isClone = SDL_FALSE;
	for (i = 1; i < argc; i++) {
		if (argv[i][0] == '-') {
			if (strcmp(argv[i], "-size") == 0) {
				isSize = SDL_TRUE;
			} else if (strcmp(argv[i], "-gzfilter") == 0) {
				isGZFilter = SDL_TRUE;
			} else if (strcmp(argv[i], "-clone") == 0) {
				isClone = SDL_TRUE;
			} else {
				printf("Option(%s) is unknown", argv[i]);
				return -1;
			}
		} else {
			/* archive name */
			break;
		}
	}
	
	if (i == argc) {
		ShowUsage(argv[0]);
		return 0;
	}
	openArgvNum = i;
	
	archiverList = ArchiverList_Create();
	if (archiverList == NULL) {
		printf("archiver list allocate error\n");
		return -1;
	}
	ArchiverList_AddArchiver(
		archiverList,
		Archive_IsTar,
		Archive_FromTar);
	ArchiverList_AddArchiver(
		archiverList,
		Archive_IsDirectory,
		Archive_FromDirectory);
	ArchiverList_AddArchiver(
		archiverList,
		Archive_IsPKZip,
		Archive_FromPKZip);
	
	if (isGZFilter) {
		orgArc = Archive_FromGZFilter(archiverList, argv[openArgvNum]);
	} else {
		orgArc = Archive_FromArchiverList(archiverList, argv[openArgvNum]);
	}
	ArchiverList_Free(archiverList);
	if (orgArc == NULL) {
		printf("\"%s\" not found\n", argv[openArgvNum]);
		return -1;
	}
	printf("\"%s\" loaded.\n", argv[openArgvNum]);
	if (isClone) {
		arc = Archive_Clone(orgArc);
		printf("Clone created.\n");
		Archive_Finish(orgArc);
	} else {
		arc = orgArc;
	}
	if (arc == NULL) {
		printf("Clone failed\n", argv[openArgvNum]);
		return -1;
	}
	
	printf("d:");
	PrintIndent(0);
	printf(
		"%s(%s)\n",
		Archive_GetCurrentDirName(arc),
		Archive_GetCurrentDirPath(arc));
	ListDirectory(arc, 0, isSize);
	
	Archive_Finish(arc);
	
	SDL_Quit();
	
	return 0;
}
