/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.jni.io;

import java.io.IOException;
import org.maachang.jni.io.CompressMemoryLzo;
import org.maachang.jni.io.DirectMemoryIO;
import org.maachang.jni.io.FastMemoryBuffer;
import org.maachang.jni.io.NativeBuffer;
import org.maachang.jni.io.NativeIO;
import org.maachang.jni.io.NormalBuffer;

public final class DecompressMemoryLzo {
    protected static final byte[] MAGIC = CompressMemoryLzo.MAGIC;
    protected static final int MAGIC_LENGTH = CompressMemoryLzo.MAGIC_LENGTH;
    protected static final int HEAD_LENGTH = CompressMemoryLzo.HEAD_LENGTH;
    protected static final int CHUNKED_HEAD = 2;
    protected static final int DEFAULT_WRK_BUFFER_LENGTH = 65536;
    protected static final int DEFAULT_TMP_BUFFER_LENGTH = 131072;
    protected static final int DEFAULT_EXEC_BUFFER_LENGTH = 65535;
    private NormalBuffer outBuffer = null;
    private long tmpAddr = 0L;
    private long wrkBuffer = 0L;
    private int wrkBufferLength = 0;
    private int adler32Code = 0;
    private int srcAdler32Code = 0;
    private int srcLength = 0;
    private int _useBufPos = 0;
    private int _useBufLen = 0;
    private long _addr = 0L;
    private int _pos = 0;
    private final int[] _wrk = new int[1];

    public DecompressMemoryLzo() throws Exception {
        this._create(-1);
    }

    protected void finalize() throws Exception {
        this.close();
    }

    private void _create(int wrkBufferLen) throws Exception {
        if (wrkBufferLen < 65536) {
            wrkBufferLen = 65536;
        }
        this.wrkBuffer = DirectMemoryIO.malloc(wrkBufferLen);
        DirectMemoryIO.memset(this.wrkBuffer, (byte)0, wrkBufferLen);
        this.wrkBufferLength = wrkBufferLen;
        this.tmpAddr = DirectMemoryIO.malloc(131072);
        this.outBuffer = null;
        this.adler32Code = 0;
        this.srcAdler32Code = 0;
        this.srcLength = 0;
        this._clear();
    }

    public void close() {
        if (this.wrkBuffer != 0L) {
            DirectMemoryIO.free(this.wrkBuffer);
            this.wrkBuffer = 0L;
            this.wrkBufferLength = 0;
        }
        if (this.tmpAddr != 0L) {
            DirectMemoryIO.free(this.tmpAddr);
            this.tmpAddr = 0L;
        }
        this.outBuffer = null;
        this.adler32Code = 0;
        this.srcAdler32Code = 0;
        this.srcLength = 0;
        this._clear();
    }

    public boolean isClose() {
        return this.wrkBuffer == 0L;
    }

    public void reset() throws Exception {
        if (this.wrkBuffer == 0L) {
            throw new IOException("\u65e2\u306b\u30af\u30ed\u30fc\u30ba\u3055\u308c\u3066\u3044\u307e\u3059");
        }
        if (this.tmpAddr != 0L) {
            DirectMemoryIO.free(this.tmpAddr);
            this.tmpAddr = 0L;
        }
        DirectMemoryIO.memset(this.wrkBuffer, (byte)0, this.wrkBufferLength);
        this.outBuffer = null;
        this.adler32Code = 0;
        this.srcAdler32Code = 0;
        this.srcLength = 0;
        this._clear();
    }

    public NormalBuffer finish() throws Exception {
        if (this.wrkBuffer == 0L) {
            throw new IOException("\u65e2\u306b\u30af\u30ed\u30fc\u30ba\u3055\u308c\u3066\u3044\u307e\u3059");
        }
        if (this.outBuffer == null) {
            throw new IOException("\u89e3\u51cd\u51e6\u7406\u304c\u884c\u308f\u308c\u3066\u3044\u307e\u305b\u3093");
        }
        if (this.srcAdler32Code != this.adler32Code) {
            throw new IOException("adler32\u304c\u4e00\u81f4\u3057\u307e\u305b\u3093(src:" + this.srcAdler32Code + "dest:" + this.adler32Code + ")");
        }
        if (this.srcLength != this._pos) {
            throw new IOException("\u9577\u3055\u304c\u4e00\u81f4\u3057\u307e\u305b\u3093");
        }
        return this.outBuffer;
    }

    public int getSize() throws Exception {
        if (this.wrkBuffer == 0L) {
            throw new IOException("\u65e2\u306b\u30af\u30ed\u30fc\u30ba\u3055\u308c\u3066\u3044\u307e\u3059");
        }
        return this._pos;
    }

    public int getSrcSize() throws Exception {
        if (this.wrkBuffer == 0L) {
            throw new IOException("\u65e2\u306b\u30af\u30ed\u30fc\u30ba\u3055\u308c\u3066\u3044\u307e\u3059");
        }
        return this.srcLength;
    }

    public int getAdler32() throws Exception {
        if (this.wrkBuffer == 0L) {
            throw new IOException("\u65e2\u306b\u30af\u30ed\u30fc\u30ba\u3055\u308c\u3066\u3044\u307e\u3059");
        }
        return this.adler32Code;
    }

    private void _clear() {
        this._useBufPos = 0;
        this._useBufLen = 0;
        this._addr = 0L;
        this._wrk[0] = 0;
    }

    public void decompress(NativeBuffer buf, int offset, int length) throws Exception {
        if (this.wrkBuffer == 0L) {
            throw new IOException("\u65e2\u306b\u30af\u30ed\u30fc\u30ba\u3055\u308c\u3066\u3044\u307e\u3059");
        }
        if (buf == null || offset < 0 || length <= 0) {
            throw new IllegalArgumentException("\u5f15\u6570\u304c\u4e0d\u6b63\u3067\u3059");
        }
        if (buf.getLength() < offset + length) {
            throw new IllegalArgumentException("\u6307\u5b9a\u5f15\u6570\u306e\u30aa\u30d5\u30bb\u30c3\u30c8\uff0b\u9577\u3055\u304c\u7b2c\u4e00\u5f15\u6570\u30d0\u30c3\u30d5\u30a1\u9577\u3092\u8d8a\u3057\u3066\u3044\u307e\u3059");
        }
        int bufPos = offset;
        int bufLen = 0;
        int allLen = 0;
        int chunkedLen = 0;
        long bufAddr = buf.getAddress();
        while (length > allLen) {
            bufLen = length - allLen >= 65535 ? 65535 : length - allLen;
            if (this._useBufLen + bufLen > 131072) {
                DirectMemoryIO.compact(this.tmpAddr, this._useBufPos, 131072, this._useBufLen - this._useBufPos);
                this._useBufLen -= this._useBufPos;
                this._useBufPos = 0;
                DirectMemoryIO.memcpy(this.tmpAddr + (long)this._useBufLen, bufAddr + (long)bufPos, bufLen);
                this._useBufLen += bufLen;
            } else {
                DirectMemoryIO.memcpy(this.tmpAddr + (long)this._useBufLen, bufAddr + (long)bufPos, bufLen);
                this._useBufLen += bufLen;
            }
            while (true) {
                if (this.outBuffer == null) {
                    if (HEAD_LENGTH > this._useBufLen) break;
                    for (int i = 0; i < MAGIC_LENGTH; ++i) {
                        if (DirectMemoryIO.get(this.tmpAddr, i) == MAGIC[i]) continue;
                        throw new IOException("LZO\u5f62\u5f0f\u3067\u306f\u3042\u308a\u307e\u305b\u3093");
                    }
                    this.srcAdler32Code = DirectMemoryIO.getInt(this.tmpAddr, MAGIC_LENGTH);
                    this.srcLength = DirectMemoryIO.getInt(this.tmpAddr, MAGIC_LENGTH + 4);
                    if ((this.srcLength & Integer.MIN_VALUE) != 0) {
                        throw new IOException("\u5fa9\u5143\u30c7\u30fc\u30bf\u9577\u304c\u4e0d\u6b63\u3067\u3059");
                    }
                    chunkedLen = DirectMemoryIO.getShort(this.tmpAddr, HEAD_LENGTH) & 0xFFFF;
                    this.outBuffer = new FastMemoryBuffer(this.srcLength);
                    this._addr = this.outBuffer.getAddress();
                    this._pos = 0;
                    if (chunkedLen + this._useBufPos + 2 > this._useBufLen) break;
                    this._useBufPos = HEAD_LENGTH;
                } else {
                    chunkedLen = DirectMemoryIO.getShort(this.tmpAddr, this._useBufPos) & 0xFFFF;
                    if (chunkedLen + this._useBufPos + 2 > this._useBufLen) break;
                }
                int res = NativeIO.lzo1xDecompress(this.tmpAddr + (long)(this._useBufPos + 2), chunkedLen, this._addr + (long)this._pos, this._wrk, this.wrkBuffer);
                if (res != 0) {
                    throw new IOException("\u89e3\u51cd\u51e6\u7406\u306b\u5931\u6557\u3057\u307e\u3057\u305f:" + res);
                }
                this.adler32Code = NativeIO.adler32(this.adler32Code, this._addr + (long)this._pos, this._wrk[0]);
                this._useBufPos += chunkedLen + 2;
                this._pos += this._wrk[0];
            }
            allLen += bufLen;
            bufPos += bufLen;
            bufLen = 0;
        }
    }

    public void decompress(byte[] buf, int offset, int length) throws Exception {
        if (this.wrkBuffer == 0L) {
            throw new IOException("\u65e2\u306b\u30af\u30ed\u30fc\u30ba\u3055\u308c\u3066\u3044\u307e\u3059");
        }
        if (buf == null || offset < 0 || length <= 0) {
            throw new IllegalArgumentException("\u5f15\u6570\u304c\u4e0d\u6b63\u3067\u3059");
        }
        if (buf.length < offset + length) {
            throw new IllegalArgumentException("\u6307\u5b9a\u5f15\u6570\u306e\u30aa\u30d5\u30bb\u30c3\u30c8\uff0b\u9577\u3055\u304c\u7b2c\u4e00\u5f15\u6570\u30d0\u30c3\u30d5\u30a1\u9577\u3092\u8d8a\u3057\u3066\u3044\u307e\u3059");
        }
        int bufPos = offset;
        int bufLen = 0;
        int allLen = 0;
        int chunkedLen = 0;
        while (length > allLen) {
            bufLen = length - allLen >= 65535 ? 65535 : length - allLen;
            if (this._useBufLen + bufLen > 131072) {
                DirectMemoryIO.compact(this.tmpAddr, this._useBufPos, 131072, this._useBufLen - this._useBufPos);
                this._useBufLen -= this._useBufPos;
                this._useBufPos = 0;
                DirectMemoryIO.putBinary(this.tmpAddr, this._useBufLen, buf, bufPos, bufLen);
                this._useBufLen += bufLen;
            } else {
                DirectMemoryIO.putBinary(this.tmpAddr, this._useBufLen, buf, bufPos, bufLen);
                this._useBufLen += bufLen;
            }
            while (true) {
                if (this.outBuffer == null) {
                    if (HEAD_LENGTH > this._useBufLen) break;
                    for (int i = 0; i < MAGIC_LENGTH; ++i) {
                        if (DirectMemoryIO.get(this.tmpAddr, i) == MAGIC[i]) continue;
                        throw new IOException("LZO\u5f62\u5f0f\u3067\u306f\u3042\u308a\u307e\u305b\u3093");
                    }
                    this.srcAdler32Code = DirectMemoryIO.getInt(this.tmpAddr, MAGIC_LENGTH);
                    this.srcLength = DirectMemoryIO.getInt(this.tmpAddr, MAGIC_LENGTH + 4);
                    if ((this.srcLength & Integer.MIN_VALUE) != 0) {
                        throw new IOException("\u5fa9\u5143\u30c7\u30fc\u30bf\u9577\u304c\u4e0d\u6b63\u3067\u3059");
                    }
                    chunkedLen = DirectMemoryIO.getShort(this.tmpAddr, HEAD_LENGTH) & 0xFFFF;
                    this.outBuffer = new FastMemoryBuffer(this.srcLength);
                    this._addr = this.outBuffer.getAddress();
                    this._pos = 0;
                    if (chunkedLen + this._useBufPos + 2 > this._useBufLen) break;
                    this._useBufPos = HEAD_LENGTH;
                } else {
                    chunkedLen = DirectMemoryIO.getShort(this.tmpAddr, this._useBufPos) & 0xFFFF;
                    if (chunkedLen + this._useBufPos + 2 > this._useBufLen) break;
                }
                int res = NativeIO.lzo1xDecompress(this.tmpAddr + (long)(this._useBufPos + 2), chunkedLen, this._addr + (long)this._pos, this._wrk, this.wrkBuffer);
                if (res != 0) {
                    throw new IOException("\u89e3\u51cd\u51e6\u7406\u306b\u5931\u6557\u3057\u307e\u3057\u305f:" + res);
                }
                this.adler32Code = NativeIO.adler32(this.adler32Code, this._addr + (long)this._pos, this._wrk[0]);
                this._useBufPos += chunkedLen + 2;
                this._pos += this._wrk[0];
            }
            allLen += bufLen;
            bufPos += bufLen;
            bufLen = 0;
        }
    }
}

