/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.jni.io;

import java.io.IOException;
import java.io.OutputStream;
import org.maachang.jni.io.DirectMemoryIO;
import org.maachang.jni.io.NativeBuffer;
import org.maachang.jni.io.NativeIO;
import org.maachang.jni.io.NativeIODefine;

public class NativeOutputStream
extends OutputStream {
    private static final int ACCESS_MODE = 1;
    private static final int IO_OPT = 1;
    private static final int TEMP_LEN = 4096;
    private long address = 0L;
    private int position = 0;
    private long handle = -1L;

    private NativeOutputStream() {
    }

    public NativeOutputStream(String name) throws Exception {
        this(true, name);
    }

    public NativeOutputStream(boolean mode, String name) throws Exception {
        if (name == null || (name = name.trim()).length() <= 0) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        name = NativeIODefine.fullPath(name);
        this.handle = mode ? (NativeIODefine.useFile(name) ? NativeIO.open(1, 1, 1, NativeIODefine.nativeString(name)) : NativeIO.open(1, 0, 1, NativeIODefine.nativeString(name))) : NativeIO.open(1, 0, 1, NativeIODefine.nativeString(name));
        if (this.handle == -1L) {
            throw new IOException("\u6307\u5b9a\u30d5\u30a1\u30a4\u30eb[" + name + "]\u306e\u30aa\u30fc\u30d7\u30f3\u306b\u5931\u6557\u3057\u307e\u3057\u305f");
        }
        this.address = DirectMemoryIO.malloc(4096);
    }

    protected void finalize() throws Exception {
        try {
            this.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void close() throws IOException {
        if (this.handle > -1L) {
            this.flush();
            NativeIO.close(this.handle);
            this.handle = -1L;
            this.position = 0;
            if (this.address != 0L) {
                DirectMemoryIO.free(this.address);
                this.address = 0L;
            }
        }
    }

    @Override
    public void flush() throws IOException {
        if (this.handle <= -1L) {
            throw new IOException("\u30d5\u30a1\u30a4\u30eb\u306f\u65e2\u306b\u30af\u30ed\u30fc\u30ba\u3057\u3066\u3044\u307e\u3059");
        }
        if (this.position > 0) {
            NativeIO.sWrite(this.handle, this.address, this.position);
            this.position = 0;
        }
    }

    @Override
    public void write(int b) throws IOException {
        if (this.handle <= -1L) {
            throw new IOException("\u30d5\u30a1\u30a4\u30eb\u306f\u65e2\u306b\u30af\u30ed\u30fc\u30ba\u3057\u3066\u3044\u307e\u3059");
        }
        if (this.position >= 4096) {
            NativeIO.sWrite(this.handle, this.address, this.position);
            this.position = 0;
        }
        DirectMemoryIO.put(this.address, this.position, (byte)b);
        ++this.position;
    }

    @Override
    public void write(byte[] b) throws IOException {
        if (b == null) {
            throw new NullPointerException("\u30d0\u30a4\u30ca\u30ea\u304c\u5b58\u5728\u3057\u307e\u305b\u3093");
        }
        this.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        block8: {
            if (this.handle <= -1L) {
                throw new IOException("\u30d5\u30a1\u30a4\u30eb\u306f\u65e2\u306b\u30af\u30ed\u30fc\u30ba\u3057\u3066\u3044\u307e\u3059");
            }
            if (b == null) {
                throw new NullPointerException("\u30d0\u30a4\u30ca\u30ea\u304c\u5b58\u5728\u3057\u307e\u305b\u3093");
            }
            if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
                throw new IndexOutOfBoundsException("\u6307\u5b9a\u7bc4\u56f2\u304c\u4e0d\u6b63\u3067\u3059");
            }
            if (len == 0) {
                return;
            }
            if (len > 4096 - this.position) {
                int plen = 4096 - this.position;
                while (true) {
                    DirectMemoryIO.putBinary(this.address, this.position, b, off, plen);
                    this.position += plen;
                    if (this.position != 4096) {
                        this.position = plen;
                        break block8;
                    }
                    NativeIO.sWrite(this.handle, this.address, this.position);
                    this.position = 0;
                    off += plen;
                    if ((len -= plen) < 4096) {
                        plen = len;
                        continue;
                    }
                    plen = 4096;
                }
            }
            DirectMemoryIO.putBinary(this.address, this.position, b, off, len);
            this.position += len;
        }
    }

    public int writeBuffer(NativeBuffer buf) throws IOException {
        if (buf == null || buf.isClear()) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        if (this.handle <= -1L) {
            throw new IOException("\u30d5\u30a1\u30a4\u30eb\u306f\u65e2\u306b\u30af\u30ed\u30fc\u30ba\u3057\u3066\u3044\u307e\u3059");
        }
        return NativeIO.sWrite(this.handle, buf.getAddress(), buf.getLength());
    }

    public int writeBuffer(NativeBuffer buf, int off, int len) throws IOException {
        int bufLen;
        if (buf == null || buf.isClear() || (bufLen = buf.getLength()) <= 0 || off < 0) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        int n = len = len <= 0 ? bufLen - off : len;
        if (len <= 0 || len > bufLen) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        if (this.handle == -1L) {
            throw new IOException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u65e2\u306b\u30af\u30ed\u30fc\u30ba\u3057\u3066\u3044\u307e\u3059");
        }
        return NativeIO.sWrite(this.handle, buf.getAddress() + (long)off, len);
    }

    public long length() throws Exception {
        if (this.handle == -1L) {
            throw new IOException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u65e2\u306b\u30af\u30ed\u30fc\u30ba\u3057\u3066\u3044\u307e\u3059");
        }
        return NativeIO.getLength(this.handle);
    }
}

