/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.jni.io;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.maachang.jni.io.AtomicSeq;
import org.maachang.jni.io.FastMemoryBuffer;
import org.maachang.jni.io.FastMmapBufferImpl;
import org.maachang.jni.io.MemoryBuffer;
import org.maachang.jni.io.MmapBuffer;
import org.maachang.jni.io.MmapBufferImpl;
import org.maachang.jni.io.NativeBuffer;
import org.maachang.jni.io.NativeIO;
import org.maachang.jni.io.NativeIODefine;

public class NativeRandomIO {
    public static final int OPT_READ = 0;
    public static final int OPT_WRITE = 2;
    protected static final int ACCESS_MODE = 0;
    protected long handle = -1L;
    protected String name = null;
    protected int opt = -1;
    protected final Map<Long, MmapBuffer> _mmapManager = new ConcurrentHashMap<Long, MmapBuffer>();
    protected final AtomicSeq _seq = new AtomicSeq(0L);

    protected NativeRandomIO() {
    }

    public NativeRandomIO(int opt, String name) throws Exception {
        long handle;
        if (name == null || (name = name.trim()).length() <= 0) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        if (opt != 0) {
            opt = 2;
        }
        if ((handle = NativeIO.open(0, 0, opt, NativeIODefine.nativeString(name = NativeIODefine.fullPath(name)))) <= -1L) {
            throw new IOException("\u30d5\u30a1\u30a4\u30eb\u30aa\u30fc\u30d7\u30f3\u306b\u5931\u6557\u3057\u307e\u3057\u305f");
        }
        this.handle = handle;
        this.name = name;
        this.opt = opt;
    }

    protected void finalize() throws Exception {
        this.close();
    }

    public void close() {
        if (this.handle != -1L) {
            for (Long key : this._mmapManager.keySet()) {
                this._mmapManager.get(key).clear();
            }
            NativeIO.fsync(this.handle);
            NativeIO.close(this.handle);
        }
        this.handle = -1L;
        this.name = null;
    }

    public void fsync() throws Exception {
        if (this.handle != -1L) {
            for (Long key : this._mmapManager.keySet()) {
                this._mmapManager.get(key).flush();
            }
            if (NativeIO.fsync(this.handle) != 0) {
                throw new IOException("fsync\u51e6\u7406\u306b\u5931\u6557");
            }
        }
    }

    public static final NativeBuffer createMemory(boolean fastMode, int length) {
        if (fastMode) {
            return new FastMemoryBuffer(length);
        }
        return new MemoryBuffer(length);
    }

    public MmapBuffer createMmap(long offset, int length) throws Exception {
        return this.createMmap(false, offset, length);
    }

    public MmapBuffer createMmap(boolean fastMode, long offset, int length) throws Exception {
        if (this.handle == -1L) {
            throw new IOException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u65e2\u306b\u30af\u30ed\u30fc\u30ba\u3057\u3066\u3044\u307e\u3059");
        }
        if (fastMode) {
            return new FastMmapBufferImpl(this, offset, length);
        }
        return new MmapBufferImpl(this, offset, length);
    }

    public int read(NativeBuffer buffer, int offset, int length) throws Exception {
        return this.read(buffer, -1L, offset, length);
    }

    public int read(NativeBuffer buffer, long seek, int offset, int length) throws Exception {
        int bufferLength;
        if (buffer == null || buffer.isClear() || (bufferLength = buffer.getLength()) <= 0 || offset < 0) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        if (this.handle == -1L) {
            throw new IOException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u65e2\u306b\u30af\u30ed\u30fc\u30ba\u3057\u3066\u3044\u307e\u3059");
        }
        int n = length = length <= 0 ? bufferLength - offset : length;
        if (length <= 0 || length > bufferLength) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        return NativeIO.read(this.handle, seek, buffer.getAddress(), offset, length);
    }

    public void write(NativeBuffer buffer, int offset, int length) throws Exception {
        this.write(buffer, -1L, offset, length);
    }

    public void write(NativeBuffer buffer, long seek, int offset, int length) throws Exception {
        int bufferLength;
        if (buffer == null || buffer.isClear() || (bufferLength = buffer.getLength()) <= 0 || offset < 0) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        if (this.handle == -1L) {
            throw new IOException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u65e2\u306b\u30af\u30ed\u30fc\u30ba\u3057\u3066\u3044\u307e\u3059");
        }
        int n = length = length <= 0 ? bufferLength - offset : length;
        if (length <= 0 || length > bufferLength) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        if (NativeIO.write(this.handle, seek, buffer.getAddress(), offset, length) <= -1) {
            throw new IOException("\u66f8\u8fbc\u307f\u51e6\u7406\u306b\u5931\u6557\u3057\u307e\u3057\u305f");
        }
    }

    public long getSeek() throws Exception {
        if (this.handle == -1L) {
            throw new IOException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u65e2\u306b\u30af\u30ed\u30fc\u30ba\u3057\u3066\u3044\u307e\u3059");
        }
        return NativeIO.getSeek(this.handle);
    }

    public long length() throws Exception {
        if (this.handle == -1L) {
            throw new IOException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u65e2\u306b\u30af\u30ed\u30fc\u30ba\u3057\u3066\u3044\u307e\u3059");
        }
        return NativeIO.getLength(this.handle);
    }

    public void length(long length) throws Exception {
        if (length <= -1L) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        if (this.handle == -1L) {
            throw new IOException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u65e2\u306b\u30af\u30ed\u30fc\u30ba\u3057\u3066\u3044\u307e\u3059");
        }
        NativeIO.setLength(this.handle, length);
    }

    public String getName() {
        return this.name;
    }

    public int getOption() {
        return this.opt;
    }

    public boolean isOpen() {
        return this.handle != -1L;
    }

    public static final int getPageFileLength() {
        return NativeIO.pageFileLength();
    }

    public static final int getPageFileShift() {
        return NativeIO.pageFileShift();
    }
}

