package org.maachang.jni.io ;

/**
 * MemoryBuffer.
 * 
 * @version 2010/06/04
 * @author  masahito suzuki
 * @since   SeabassNativeIO-1.0.0
 */
public class MemoryBuffer
    extends AbstractNativeBuffer implements NormalBuffer {
    private MemoryBuffer() {
        
    }
    
    /**
     * コンストラクタ.
     * @param length Native生成するメモリサイズを設定します.
     */
    public MemoryBuffer( int length ) {
        create( length ) ;
    }
    
    /**
     * デストラクタ.
     */
    protected void finalize() throws Exception {
        clear() ;
    }
    
    /**
     * メモリ生成.
     * @param length Native生成するメモリサイズを設定します.
     */
    public void create( int length ) {
        if( length <= 0 ) {
            throw new IllegalArgumentException( "メモリサイズが不正です" ) ;
        }
        clear() ;
        this.address = NativeIO.malloc( length ) ;
        this.length = length ;
    }
    
    /**
     * メモリクリア.
     */
    public void clear() {
        if( address != 0L ) {
            NativeIO.free( address ) ;
            address = 0L ;
            length = 0 ;
        }
    }
    
    /**
     * メモリ領域再生成.
     * @param length 再生成するメモリサイズを設定します.
     */
    public void reCreate( int length ) {
        if( length <= 0 ) {
            throw new IllegalArgumentException( "メモリサイズが不正です" ) ;
        }
        if( this.address == 0L ) {
            throw new IllegalStateException( "既にクリアされています" ) ;
        }
        this.address = NativeIO.realloc( address,length ) ;
        this.length = length ;
    }
    
}

