package org.maachang.jni.io ;

import java.nio.ByteBuffer;

/**
 * DirectByteBufferをNativeBuffer操作するインターフェイス.
 * 
 * @version 2010/06/04
 * @author  masahito suzuki
 * @since   SeabassNativeIO-1.0.0
 */
public interface NativeByteBuffer extends NativeBuffer {
    /**
     * 情報生成.
     * @param byteBuffer 対象のByteBufferを設定します.
     * @exception Exception 例外.
     */
    public void create( ByteBuffer buf ) throws Exception ;
    
    /**
     * 情報生成.
     * @param byteBuffer 対象のByteBufferを設定します.
     * @param offset 対象のオフセット値を設定します.
     * @param length 対象のデータ長を設定します.
     * @exception Exception 例外.
     */
    public void create( ByteBuffer buf,int offset,int length ) throws Exception ;
    
    /**
     * ByteBufferを取得.
     * @return ByteBuffer ByteBufferオブジェクトが返されます.
     */
    public ByteBuffer getByteBuffer() ;
    
    /**
     * positionを取得.
     * @return int ByteBufferのポジションが返されます.
     */
    public int position() ;
    
    /**
     * positionを設定.
     * @param pos ByteBufferのポジションを設定します.
     */
    public void position( int pos ) ;
    
    /**
     * limitを取得.
     * @return int ByteBufferのリミットが返されます.
     */
    public int limit() ;
    
    /**
     * limitを設定.
     * @param lim ByteBufferのリミットを設定します.
     */
    public void limit( int lim ) ;
}
