/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.mimdb.core;

import java.util.Arrays;
import org.maachang.mimdb.MimdbException;
import org.maachang.mimdb.core.MimdbTable;
import org.maachang.mimdb.core.MimdbTableInstance;
import org.maachang.mimdb.core.MimdbTableManager;
import org.maachang.mimdb.core.impl.MimdbUtils;
import org.maachang.mimdb.core.util.Config;
import org.maachang.mimdb.core.util.Csv;

final class MimdbCsvTable {
    private MimdbCsvTable() {
    }

    /*
     * Unable to fully structure code
     */
    public static final String create(String baseFolder, Config conf) throws Exception {
        block19: {
            if (baseFolder != null) {
                if (!(baseFolder = MimdbUtils.getFullPath(baseFolder)).endsWith("/")) {
                    baseFolder = String.valueOf(baseFolder) + "/";
                }
                csvName = MimdbUtils.getFullPath(String.valueOf(baseFolder) + conf.getString("csv", "file", 0));
            } else {
                csvName = MimdbUtils.getFullPath(conf.getString("csv", "file", 0));
            }
            if (!MimdbUtils.isFile(csvName)) {
                throw new MimdbException("\u6307\u5b9aCSV\u30d5\u30a1\u30a4\u30eb[" + csvName + "]\u306f\u5b58\u5728\u3057\u307e\u305b\u3093");
            }
            charset = conf.getString("csv", "charset", 0);
            if (charset == null || (charset = charset.trim()).length() <= 0) {
                charset = "Windows-31J";
            }
            if ((cutCode = conf.getString("csv", "cut", 0)) == null || cutCode.length() <= 0) {
                cutCode = ",";
            }
            lineNo = -1;
            id = -1L;
            beforeId = -1L;
            orderList = null;
            tableName = null;
            csv = null;
            try {
                block20: {
                    try {
                        block21: {
                            tableName = MimdbTableInstance.getTableName(conf);
                            columns = MimdbCsvTable.getColumnNames(conf);
                            types = MimdbCsvTable.getColumnTypes(conf, tableName);
                            primary = MimdbTableInstance.getPrimaryKey(conf);
                            index = MimdbTableInstance.getIndexNames(conf);
                            ngram = MimdbTableInstance.getNGramIndexNames(conf);
                            compress = MimdbTableInstance.getCompressFlag(conf);
                            compressLength = MimdbTableInstance.getCompressLength(conf);
                            csv = new Csv(csvName, charset, cutCode);
                            beforeId = MimdbTableManager.getInstance().getId(tableName);
                            id = MimdbTableInstance.begin(tableName);
                            table = new MimdbTable(id, tableName, 4096, columns, types, primary, index, ngram, compress, compressLength);
                            columnsLength = columns.length;
                            lineNo = 1;
                            if (!conf.getBoolean("csv", "header", 0)) ** GOTO lbl52
                            header = false;
                            headerArray = null;
                            csvOrder = null;
                            while (csv.next()) {
                                if (!header) {
                                    headerArray = csv.getObjects();
                                    header = true;
                                    csvOrder = MimdbCsvTable.headerOrder(columns, headerArray, tableName);
                                    continue;
                                }
                                orderList = csv.getObjects();
                                table.add(MimdbCsvTable.orderArray(csvOrder, orderList, columnsLength, lineNo++, tableName));
                            }
                            break block21;
lbl-1000:
                            // 1 sources

                            {
                                orderList = csv.getObjects();
                                table.add(MimdbCsvTable.orderArray(null, orderList, columnsLength, lineNo++, tableName));
lbl52:
                                // 2 sources

                                ** while (csv.next())
                            }
                        }
                        csv.close();
                        csv = null;
                        table.fix();
                        MimdbTableManager.getInstance().put(table);
                        break block19;
                    }
                    catch (Exception e) {
                        tblName = tableName;
                        if (beforeId != -1L) {
                            MimdbTableInstance.errorEnd(tableName, beforeId);
                        }
                        tableName = null;
                        if (orderList == null) break block20;
                        len = orderList.length;
                        buf = new StringBuilder();
                        i = 0;
                        ** while (i < len)
                    }
lbl-1000:
                    // 1 sources

                    {
                        if (i != 0) {
                            buf.append(",");
                        }
                        buf.append(orderList[i]);
                        ++i;
                        continue;
                    }
lbl76:
                    // 1 sources

                    throw new MimdbException("[" + tblName + "]\u306e\u8aad\u307f\u8fbc\u307f\u306b\u5931\u6557\u3057\u307e\u3057\u305f(line:" + lineNo + ")\n[" + buf.toString() + "]", e);
                }
                throw new MimdbException("[" + tblName + "]\u306e\u8aad\u307f\u8fbc\u307f\u306b\u5931\u6557\u3057\u307e\u3057\u305f(line:" + lineNo + ")", e);
            }
            finally {
                if (tableName != null) {
                    MimdbTableInstance.end(tableName);
                }
                if (csv != null) {
                    csv.close();
                }
            }
        }
        return tableName;
    }

    private static final String[] getColumnNames(Config conf) throws Exception {
        return conf.getKeys("column");
    }

    private static final int[] getColumnTypes(Config conf, String tableName) throws Exception {
        String[] columns = conf.getKeys("column");
        if (columns == null || columns.length <= 0) {
            throw new MimdbException("CSV\u5b9a\u7fa9[" + tableName + "]\u306e\u30ab\u30e9\u30e0\u540d\u306f\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
        }
        int len = columns.length;
        int[] ret = new int[len];
        int i = 0;
        while (i < len) {
            String val = conf.getString("column", columns[i], 0);
            if (val == null || (val = val.trim()).length() <= 0) {
                throw new MimdbException("CSV\u5b9a\u7fa9[" + tableName + "]\u306e\u30ab\u30e9\u30e0[" + columns[i] + "]\u306b\u5bfe\u3059\u308b\u578b\u5b9a\u7fa9\u306f\u4e0d\u6b63\u3067\u3059");
            }
            if ("boolean".equals(val = val.toLowerCase())) {
                ret[i] = 1;
            } else if ("int".equals(val)) {
                ret[i] = 2;
            } else if ("long".equals(val)) {
                ret[i] = 3;
            } else if ("float".equals(val)) {
                ret[i] = 4;
            } else if ("double".equals(val)) {
                ret[i] = 4;
            } else if ("string".equals(val)) {
                ret[i] = 5;
            } else if ("varchar".equals(val)) {
                ret[i] = 5;
            } else if ("date".equals(val)) {
                ret[i] = 7;
            } else if ("time".equals(val)) {
                ret[i] = 8;
            } else if ("timestamp".equals(val)) {
                ret[i] = 6;
            } else {
                throw new MimdbException("CSV\u5b9a\u7fa9[" + tableName + "]\u306e\u30ab\u30e9\u30e0[" + columns[i] + "]\u306b\u5bfe\u3059\u308b\u578b\u5b9a\u7fa9[" + val + "]\u306f\u4e0d\u6b63\u3067\u3059");
            }
            ++i;
        }
        return ret;
    }

    private static final int[] headerOrder(String[] columns, Object[] headerArray, String tableName) throws Exception {
        int len = headerArray.length;
        if (columns.length != len) {
            throw new MimdbException("CSV\u5b9a\u7fa9[" + tableName + "]\u306e\u30ab\u30e9\u30e0\u6570\u304c\u3001CSV\u30d8\u30c3\u30c0\u6570\u3068\u4e00\u81f4\u3057\u307e\u305b\u3093");
        }
        int[] ret = new int[len];
        Arrays.fill(ret, -1);
        int i = 0;
        while (i < len) {
            String n = (String)headerArray[i];
            int j = 0;
            while (j < len) {
                if (n.equals(columns[j])) {
                    if (ret[i] != -1) {
                        throw new MimdbException("CSV\u5b9a\u7fa9[" + tableName + "]\u306e\u30ab\u30e9\u30e0\u540d[" + columns[j] + "]\u304c\u8907\u6570\u5b9a\u7fa9\u3055\u308c\u3066\u3044\u307e\u3059");
                    }
                    ret[i] = j;
                    break;
                }
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < len) {
            if (ret[i] == -1) {
                throw new MimdbException("CSV\u5b9a\u7fa9[" + tableName + "]\u306eCSV\u30d8\u30c3\u30c0\u6574\u5408\u6027\u304c\u4e0d\u6b63\u3067\u3059");
            }
            ++i;
        }
        int c = -1;
        int i2 = 0;
        while (i2 < len) {
            if (c == -1) {
                c = ret[i2];
            } else {
                if (c + 1 != ret[i2]) {
                    return ret;
                }
                c = ret[i2];
            }
            ++i2;
        }
        return null;
    }

    private static final Object[] orderArray(int[] order, Object[] values, int len, int no, String tableName) throws Exception {
        if (len != values.length) {
            throw new MimdbException("CSV\u5b9a\u7fa9[" + tableName + "]\u306e\u30ab\u30e9\u30e0\u6570\u304c\u3001CSV\u8981\u7d20\u6570\u3068\u4e00\u81f4\u3057\u307e\u305b\u3093(\u884c:" + no + ")");
        }
        if (order == null) {
            return values;
        }
        Object[] ret = new Object[len];
        int i = 0;
        while (i < len) {
            ret[order[i]] = values[i];
            ++i;
        }
        return ret;
    }
}

