/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.mimdb.core.impl;

import org.maachang.mimdb.core.MimdbMiddleSearch;
import org.maachang.mimdb.core.ResultArray;
import org.maachang.mimdb.core.impl.Flags;
import org.maachang.mimdb.core.impl.FlagsAnd;
import org.maachang.mimdb.core.impl.FlagsBase;

public final class FlagsMiddleSearch
implements MimdbMiddleSearch {
    protected long dbId = -1L;
    protected Flags noList = null;
    protected int max = -1;
    protected int useSize = -1;

    public FlagsMiddleSearch() {
    }

    public FlagsMiddleSearch(long id, int len) {
        this.create(id, len);
    }

    public final void create(long id, int len) {
        this.max = len;
        this.dbId = id;
        this.noList = new FlagsBase(len);
    }

    public final void create(long id, Flags f) {
        this.useSize = -1;
        this.dbId = id;
        if (f.isAnd()) {
            this.noList = f;
            ((FlagsAnd)f).create(f);
        } else {
            this.noList = new FlagsAnd(f);
        }
        this.max = this.noList.max;
    }

    public final void clear() {
        this.dbId = -1L;
        this.noList = null;
        this.max = -1;
        this.useSize = -1;
    }

    public final long getDbId() {
        return this.dbId;
    }

    public final void add(int no) {
        this.noList.add(no);
    }

    public final void addArray(int[] no) {
        this.noList.addArray(no);
    }

    public final void off(int no) {
        this.noList.set(no, 0);
    }

    public final void offArray(int[] no) {
        this.noList.setArray(no, 0);
    }

    public final void all() {
        this.noList.all();
    }

    public final void or(MimdbMiddleSearch search) {
        if (this.noList.isAnd()) {
            this.noList = new FlagsBase(this.noList);
        }
        this.noList.marge(((FlagsMiddleSearch)search).noList);
    }

    public final void and(MimdbMiddleSearch search) {
        if (!this.noList.isAnd()) {
            this.noList = new FlagsAnd(this.noList);
        }
        this.noList.marge(((FlagsMiddleSearch)search).noList);
    }

    public final void getResultArray(ResultArray[] out, int off) {
        this.noList.getResultArray(out, off);
    }

    public void clearCache() {
        this.useSize = -1;
        this.noList.clearAndPosition();
    }

    public final int size() {
        if (this.useSize == -1) {
            this.useSize = this.noList.size();
        }
        return this.useSize;
    }

    public final boolean isAnd() {
        return this.noList.isAnd();
    }

    public final String toString() {
        return (this.noList.isAnd() ? "and" : "or") + " size:" + this.size();
    }
}

