/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.mimdb.core.util;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.maachang.mimdb.core.impl.MimdbUtils;
import org.maachang.mimdb.core.util.ReadIni;

public class Config {
    private Map<String, Map<String, List<Object>>> params = new HashMap<String, Map<String, List<Object>>>();
    private Map<String, List<Object>> keyByNum = new HashMap<String, List<Object>>();
    private String srcName = null;

    public static final boolean read(Config conf, String name) throws Exception {
        if (!MimdbUtils.isFile(name)) {
            throw new IOException("\u6307\u5b9a\u30d5\u30a1\u30a4\u30eb\u540d[" + name + "]\u306e\u5185\u5bb9\u306f\u5b58\u5728\u3057\u307e\u305b\u3093");
        }
        BufferedReader br = null;
        try {
            br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(name), "UTF8"));
            ReadIni.analisys(conf, br);
            conf.srcName = MimdbUtils.getFullPath(name);
            br.close();
            br = null;
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (Exception exception) {}
            }
        }
        return true;
    }

    public static final Config read(String name) throws Exception {
        Config ret = new Config();
        Config.read(ret, name);
        return ret;
    }

    public void clear() {
        this.params.clear();
        this.keyByNum.clear();
        this.srcName = null;
    }

    public void put(String section, String key, String value) {
        List<Object> keyValue;
        if (section == null || key == null) {
            return;
        }
        if (value == null) {
            value = "";
        }
        section = section.trim();
        key = key.trim();
        List<Object> keys = this.keyByNum.get(section);
        Map<String, List<Object>> sectionValue = this.params.get(section);
        if (sectionValue == null) {
            sectionValue = new HashMap<String, List<Object>>();
            this.params.put(section, sectionValue);
            keys = new ArrayList<Object>();
            this.keyByNum.put(section, keys);
        }
        if ((keyValue = sectionValue.get(key)) == null) {
            keyValue = new ArrayList<Object>();
            sectionValue.put(key, keyValue);
            keys.add(key);
        }
        keyValue.add(value);
    }

    public void set(String section, String key, String value) {
        List<Object> keyValue;
        if (section == null || key == null) {
            return;
        }
        if (value == null) {
            value = "";
        }
        section = section.trim();
        key = key.trim();
        Map<String, List<Object>> sectionValue = this.params.get(section);
        if (sectionValue == null) {
            sectionValue = new HashMap<String, List<Object>>();
            this.params.put(section, sectionValue);
        }
        if ((keyValue = sectionValue.get(key)) == null) {
            keyValue = new ArrayList<Object>();
            sectionValue.put(key, keyValue);
        } else {
            keyValue.clear();
        }
        keyValue.add(value);
    }

    public String get(String section, String key, int no) {
        List<Object> value;
        if (section == null || key == null || no < 0) {
            return null;
        }
        section = section.trim();
        key = key.trim();
        Map<String, List<Object>> sectionValue = this.params.get(section);
        if (sectionValue != null && (value = sectionValue.get(key)) != null && value.size() > no) {
            return (String)value.get(no);
        }
        return null;
    }

    public boolean getBoolean(String section, String key, int no) throws Exception {
        return MimdbUtils.convertBool(this.get(section, key, no));
    }

    public int getInt(String section, String key, int no) throws Exception {
        return MimdbUtils.convertInt(this.get(section, key, no));
    }

    public long getLong(String section, String key, int no) throws Exception {
        return MimdbUtils.convertLong(this.get(section, key, no));
    }

    public double getDouble(String section, String key, int no) throws Exception {
        return MimdbUtils.convertDouble(this.get(section, key, no));
    }

    public String getString(String section, String key, int no) throws Exception {
        return MimdbUtils.convertString(this.get(section, key, no));
    }

    public java.sql.Date getSqlDate(String section, String key, int no) throws Exception {
        return MimdbUtils.convertSqlDate(this.get(section, key, no));
    }

    public Time getSqlTime(String section, String key, int no) throws Exception {
        return MimdbUtils.convertSqlTime(this.get(section, key, no));
    }

    public Timestamp getSqlTimestamp(String section, String key, int no) throws Exception {
        return MimdbUtils.convertSqlTimestamp(this.get(section, key, no));
    }

    public Date getDate(String section, String key, int no) throws Exception {
        return MimdbUtils.convertSqlTimestamp(this.get(section, key, no));
    }

    public String[] getAll(String section, String key) {
        List<Object> value;
        if (section == null || key == null) {
            return null;
        }
        section = section.trim();
        key = key.trim();
        Map<String, List<Object>> sectionValue = this.params.get(section);
        if (sectionValue != null && (value = sectionValue.get(key)) != null && value.size() > 0) {
            int len = value.size();
            String[] ret = new String[len];
            int i = 0;
            while (i < len) {
                ret[i] = (String)value.get(i);
                ++i;
            }
            return ret;
        }
        return null;
    }

    public void removeSection(String section) {
        if (section == null) {
            return;
        }
        this.params.remove(section);
        this.keyByNum.remove(section);
    }

    public void removeKey(String section, String key) {
        if (section == null || key == null) {
            return;
        }
        section = section.trim();
        key = key.trim();
        Map<String, List<Object>> sectionValue = this.params.get(section);
        if (sectionValue != null) {
            sectionValue.remove(key);
            List<Object> keys = this.keyByNum.get(section);
            if (keys != null && keys.size() > 0) {
                int len = keys.size();
                int i = 0;
                while (i < len) {
                    if (key.equals(keys.get(i))) {
                        keys.remove(i);
                        break;
                    }
                    ++i;
                }
            }
        }
    }

    public int size(String section, String key) {
        List<Object> value;
        if (section == null || key == null) {
            return -1;
        }
        section = section.trim();
        key = key.trim();
        Map<String, List<Object>> sectionValue = this.params.get(section);
        if (sectionValue != null && (value = sectionValue.get(key)) != null) {
            return value.size();
        }
        return -1;
    }

    public int size(String section) {
        if (section == null) {
            return -1;
        }
        Map<String, List<Object>> sectionValue = this.params.get(section = section.trim());
        if (sectionValue != null) {
            return sectionValue.size();
        }
        return 0;
    }

    public int size() {
        return this.params.size();
    }

    public String[] getKeys(String section) {
        if (section == null) {
            return null;
        }
        section = section.trim();
        List<Object> keys = this.keyByNum.get(section);
        String[] ret = null;
        if (keys != null && keys.size() > 0) {
            int len = keys.size();
            ret = new String[len];
            int i = 0;
            while (i < len) {
                ret[i] = (String)keys.get(i);
                ++i;
            }
        }
        return ret;
    }

    public Object[] getSections() {
        if (this.params != null && this.params.size() > 0) {
            return this.params.keySet().toArray();
        }
        return null;
    }

    public boolean isKeys(String section, String key) {
        if (section == null) {
            return false;
        }
        Map<String, List<Object>> sectionValue = this.params.get(section = section.trim());
        if (sectionValue != null) {
            return sectionValue.get(key) != null;
        }
        return false;
    }

    public boolean isSection(String section) {
        if (section == null) {
            return false;
        }
        section = section.trim();
        return this.params.containsKey(section);
    }

    public Config getSectionByConfig(String section) {
        if (section == null) {
            return null;
        }
        if (!this.params.containsKey(section = section.trim())) {
            return null;
        }
        Map<String, List<Object>> n = this.params.get(section);
        Config ret = new Config();
        for (String key : n.keySet()) {
            List<Object> lst = n.get(key);
            int len = lst.size();
            int i = 0;
            while (i < len) {
                ret.put(section, key, (String)lst.get(i));
                ++i;
            }
        }
        return ret;
    }

    public String getSrcName() {
        return this.srcName;
    }

    public String toString() {
        if (this.params != null && this.params.size() > 0) {
            StringBuilder buf = new StringBuilder();
            Object[] objs = this.params.keySet().toArray();
            int len = objs.length;
            int i = 0;
            while (i < len) {
                buf.append("[").append(objs[i]).append("]\n");
                Map<String, List<Object>> key = this.params.get(objs[i]);
                if (key != null && key.size() > 0) {
                    Object[] sObjs = key.keySet().toArray();
                    int lenJ = sObjs.length;
                    int j = 0;
                    while (j < lenJ) {
                        buf.append("  ").append(sObjs[j]).append("\n");
                        List<Object> emt = key.get(sObjs[j]);
                        if (emt != null && emt.size() > 0) {
                            int lenK = emt.size();
                            buf.append("    ");
                            int k = 0;
                            while (k < lenK) {
                                if (k != 0) {
                                    buf.append(",");
                                }
                                buf.append(emt.get(k));
                                ++k;
                            }
                            buf.append("\n");
                        }
                        ++j;
                    }
                }
                ++i;
            }
            return buf.toString();
        }
        return "null";
    }
}

