package org.maachang.mimdb.core;


/**
 * 検索結果情報.
 * 
 * @version 2013/10/11
 * @author masahito suzuki
 * @since MasterInMemDB 1.00
 */
public interface MimdbResult extends MimdbBase {
    
    /**
     * 情報クリア.
     */
    public void clear() ;
    
    /**
     * メタデータを取得.
     * @return MimdbMetaData メタデータが返却されます.
     */
    public MimdbMetaData getMetaData() ;
    
    /**
     * 結果データ数を取得.
     * @return int 結果データ数が返却されます.
     */
    public int length() ;
    
    /**
     * 最大データ長を取得.
     * ※offset,limit値をセットした場合のみ有効.
     * @return int 最大データ長が返却されます.
     */
    public int maxLength() ;
    
    /**
     * 最初の行に移動.
     * @return boolean [true]の場合、存在します.
     * @exception Exception 例外.
     */
    public boolean first() throws Exception ;
    
    /**
     * 最後の行に移動.
     * @return boolean [true]の場合、存在します.
     * @exception Exception 例外.
     */
    public boolean last() throws Exception ;
    
    /**
     * 次の情報が存在するかチェック.
     * @return boolean [true]の場合、存在します.
     */
    public boolean next() ;
    
    /**
     * 指定行に移動.
     * @param no 対象の行番号を設定します.
     * @return boolean [true]の場合、存在します.
     * @exception Exception 例外.
     */
    public boolean absolute( int no ) throws Exception ;
    
    /**
     * 現在の行番号を取得.
     * @return int 現在の行番号が返却されます.
     */
    public int getRow() ;
    
    /**
     * 結果データの取得.
     * @return MimdbResultRow 結果行情報が返却されます.
     * @exception Exception 例外.
     */
    public MimdbResultRow get() throws Exception ;
    
    /**
     * 結果データの取得.
     * ※この条件では、カーソルは移動されません.
     * @param no 対象の行番号を設定します.
     * @return MimdbResultRow 結果行情報が返却されます.
     * @exception Exception 例外.
     */
    public MimdbResultRow get( int no ) throws Exception ;
    
    /**
     * オフセット値を取得.
     * @return int オフセット値が返却されます.
     */
    public int offset() ;
    
}

