/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.mimdb;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.maachang.mimdb.Mimdb;
import org.maachang.mimdb.MimdbException;
import org.maachang.mimdb.core.MimdbTableInstance;
import org.maachang.mimdb.core.MimdbTableManager;
import org.maachang.mimdb.core.impl.MimdbUtils;
import org.maachang.mimdb.core.util.Config;

public final class MimdbDatabase {
    private Config conf = null;
    private String baseFolder = null;
    private Map<String, String> tableConfigList = null;
    private String[] tableNames = null;
    private String name = null;
    private boolean useFlag = false;
    private ReentrantReadWriteLock sync = new ReentrantReadWriteLock();

    private MimdbDatabase() {
    }

    public MimdbDatabase(String name) throws Exception {
        this(Config.read(Mimdb.getInstance().aliasNames.containsKey(name.toLowerCase()) ? Mimdb.getInstance().aliasNames.get(name.toLowerCase()) : name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MimdbDatabase(Config conf) throws Exception {
        if (MimdbDatabase.isUse(conf)) {
            this.sync.writeLock().lock();
            try {
                this.init(conf);
                this.conf = conf;
                this.useFlag = true;
            }
            finally {
                this.sync.writeLock().unlock();
            }
            Mimdb.getInstance().manager.put(this.name, this);
        }
    }

    protected static final boolean isUse(String name) throws Exception {
        return MimdbDatabase.isUse(Config.read(Mimdb.getInstance().aliasNames.containsKey(name.toLowerCase()) ? Mimdb.getInstance().aliasNames.get(name.toLowerCase()) : name));
    }

    protected static final boolean isUse(Config conf) throws Exception {
        if (!conf.isSection("database")) {
            throw new MimdbException("database\u30bb\u30af\u30b7\u30e7\u30f3\u304c\u5b58\u5728\u3057\u307e\u305b\u3093");
        }
        return conf.getBoolean("database", "use", 0);
    }

    private final void init(Config conf) throws Exception {
        int i;
        int len;
        if (!conf.isSection("database")) {
            throw new MimdbException("database\u30bb\u30af\u30b7\u30e7\u30f3\u304c\u5b58\u5728\u3057\u307e\u305b\u3093");
        }
        String nm = conf.getString("database", "name", 0);
        if (nm == null || (nm = nm.trim().toLowerCase()).length() <= 0) {
            throw new MimdbException("\u30c7\u30fc\u30bf\u30d9\u30fc\u30b9\u540d\u304c\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
        }
        String bs = conf.getString("database", "base", 0);
        if (bs == null || (bs = bs.trim()).length() <= 0) {
            bs = null;
        }
        if ((len = conf.size("database", "table")) <= 0) {
            throw new MimdbException("\u30c6\u30fc\u30d6\u30eb\u5b9a\u7fa9\u304c\uff11\u3064\u3082\u884c\u308f\u308c\u3066\u3044\u307e\u305b\u3093");
        }
        String[] list = new String[len];
        for (i = 0; i < len; ++i) {
            list[i] = conf.getString("database", "table", i);
            if (list[i] == null || (list[i] = list[i].trim()).length() <= 0) {
                throw new MimdbException("[database]\u30bb\u30af\u30b7\u30e7\u30f3\u306etable(" + (i + 1) + ")\u304c\u6b63\u3057\u304f\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
            }
            if (list[i].toLowerCase().endsWith(".conf")) continue;
            int n = i;
            list[n] = list[n] + ".conf";
        }
        if (bs == null) {
            for (i = 0; i < len; ++i) {
                list[i] = MimdbUtils.getFullPath(list[i]);
            }
        } else {
            if (!(bs = MimdbUtils.getFullPath(bs)).endsWith("/")) {
                bs = bs + "/";
            }
            for (i = 0; i < len; ++i) {
                list[i] = MimdbUtils.getFullPath(bs + list[i]);
            }
        }
        HashMap<String, String> map = new HashMap<String, String>();
        String[] tbls = new String[len];
        for (int i2 = 0; i2 < len; ++i2) {
            tbls[i2] = MimdbTableInstance.create(bs, list[i2]);
            map.put(tbls[i2], list[i2]);
        }
        this.baseFolder = bs;
        this.tableConfigList = map;
        this.tableNames = tbls;
        this.name = nm;
    }

    public void destroy() {
        this.conf = null;
        this.baseFolder = null;
        this.tableConfigList = null;
        this.tableNames = null;
        this.name = null;
        MimdbTableManager.getInstance().destroy();
        this.useFlag = false;
    }

    public boolean isUse() {
        return this.useFlag;
    }

    public String getName() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getBaseFolder() {
        this.sync.readLock().lock();
        try {
            String string = this.baseFolder;
            return string;
        }
        finally {
            this.sync.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getTables() {
        this.sync.readLock().lock();
        try {
            String[] stringArray = this.tableNames;
            return stringArray;
        }
        finally {
            this.sync.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int length() {
        this.sync.readLock().lock();
        try {
            int n = this.tableNames.length;
            return n;
        }
        finally {
            this.sync.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isTable(String name) {
        this.sync.readLock().lock();
        try {
            boolean bl = this.tableConfigList.containsKey(name.trim().toLowerCase());
            return bl;
        }
        finally {
            this.sync.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean reload(String name) throws Exception {
        this.sync.writeLock().lock();
        try {
            name = name.trim().toLowerCase();
            String file = this.tableConfigList.get(name);
            if (file == null) {
                boolean bl = false;
                return bl;
            }
            String res = MimdbTableInstance.create(this.baseFolder, file);
            if (!name.equals(res)) {
                MimdbTableManager.getInstance().remove(name);
                this.tableConfigList.remove(name);
                this.tableConfigList.put(res, file);
                int len = this.tableNames.length;
                if (this.tableConfigList.size() != len) {
                    String[] lst = new String[this.tableConfigList.size()];
                    int cnt = 0;
                    Iterator<String> it = this.tableConfigList.keySet().iterator();
                    while (it.hasNext()) {
                        lst[cnt++] = it.next();
                    }
                    this.tableNames = lst;
                } else {
                    for (int i = 0; i < len; ++i) {
                        if (!this.tableNames[i].equals(name)) continue;
                        this.tableNames[i] = res;
                    }
                }
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.sync.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reloadAll() throws Exception {
        this.sync.writeLock().lock();
        try {
            String[] bk = this.tableNames;
            this.init(this.conf);
            int len = bk.length;
            MimdbTableManager man = MimdbTableManager.getInstance();
            for (int i = 0; i < len; ++i) {
                if (this.tableConfigList.containsKey(bk[i])) continue;
                man.remove(bk[i]);
            }
        }
        finally {
            this.sync.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadAll() throws Exception {
        this.sync.writeLock().lock();
        try {
            String file = this.conf.getSrcName();
            if (file == null) {
                throw new IOException("MimdbEmbedded\u306e\u8aad\u307f\u8fbc\u307f\u306f\u30d5\u30a1\u30a4\u30eb\u7d4c\u7531\u3067\u306f\u7121\u3044\u306e\u3067\u3001\u518d\u8aad\u307f\u8fbc\u307f\u3067\u304d\u307e\u305b\u3093");
            }
            Config bk = this.conf;
            try {
                this.conf = Config.read(file);
                this.reloadAll();
            }
            catch (Exception e) {
                MimdbTableManager.getInstance().destroy();
                this.conf = bk;
                this.reloadAll();
                throw e;
            }
        }
        finally {
            this.sync.writeLock().unlock();
        }
    }

    public String getSrcName() {
        return this.conf.getSrcName();
    }
}

