/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.mimdb.core;

import org.maachang.mimdb.MimdbException;
import org.maachang.mimdb.core.CountMetaDataImpl;
import org.maachang.mimdb.core.CountResultRowImpl;
import org.maachang.mimdb.core.MetaDataImpl;
import org.maachang.mimdb.core.MimdbBase;
import org.maachang.mimdb.core.MimdbIndex;
import org.maachang.mimdb.core.MimdbMiddleSearch;
import org.maachang.mimdb.core.MimdbResult;
import org.maachang.mimdb.core.MimdbSearchElement;
import org.maachang.mimdb.core.MimdbTable;
import org.maachang.mimdb.core.MimdbTableManager;
import org.maachang.mimdb.core.QueryCompileInfo;
import org.maachang.mimdb.core.ResultCache;
import org.maachang.mimdb.core.ResultImpl;
import org.maachang.mimdb.core.ResultRowImpl;
import org.maachang.mimdb.core.SortElement;
import org.maachang.mimdb.core.impl.EqualsNoList;
import org.maachang.mimdb.core.impl.MimdbUtils;
import org.maachang.mimdb.core.impl.WhereBlock;

public class MimdbQueryPrepared
implements MimdbBase {
    protected QueryCompileInfo info = null;
    private MimdbSearchElement[] executionParams = null;
    private int viewOffset = -1;
    private int viewLimit = -1;

    public MimdbQueryPrepared() {
    }

    public MimdbQueryPrepared(QueryCompileInfo o) {
        this.create(o);
    }

    protected void finalize() throws Exception {
        this.clear();
    }

    public void create(QueryCompileInfo o) {
        if (o == null) {
            throw new MimdbException("QueryCompileInfo\u304c\u5b9a\u7fa9\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
        }
        this.info = o;
        this.executionParams = null;
        this.viewOffset = -1;
        this.viewLimit = -1;
    }

    public void clear() {
        this.info = null;
        this.executionParams = null;
        this.viewOffset = -1;
        this.viewLimit = -1;
    }

    public boolean isClear() {
        return this.info == null;
    }

    protected final void check() {
        if (this.info == null) {
            throw new MimdbException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u30af\u30ea\u30a2\u3055\u308c\u3066\u3044\u307e\u3059");
        }
    }

    @Override
    public long getDbId() {
        this.check();
        return this.info.dbId;
    }

    public String getName() {
        this.check();
        return this.info.name;
    }

    public int paramsLength() {
        this.check();
        return this.info.preparedParamsSize;
    }

    public MimdbQueryPrepared clearParams() {
        this.check();
        this.executionParams = null;
        return this;
    }

    public MimdbQueryPrepared setParams(int index, Object value) {
        this.check();
        if (this.info.preparedParams == null || index < 0 || index >= this.info.preparedParamsSize) {
            return this;
        }
        if (this.executionParams == null) {
            this.executionParams = new MimdbSearchElement[this.info.preparedParamsSize];
        }
        this.executionParams[index] = this.info.preparedParams[index];
        this.executionParams[index].setValue(value);
        return this;
    }

    public String paramNoByColumnName(int index) {
        this.check();
        if (this.info.preparedParams == null || index < 0 || index >= this.info.preparedParamsSize) {
            return null;
        }
        return this.info.preparedParams[index].getColumn();
    }

    public int paramNoByColumnNo(int index) {
        this.check();
        if (this.info.preparedParams == null || index < 0 || index >= this.info.preparedParamsSize) {
            return -1;
        }
        MimdbSearchElement em = this.info.preparedParams[index];
        if (em.isOffLimit()) {
            return -1;
        }
        return MimdbTableManager.getInstance().get(this.info.name).getColumnNameByNo(em.getColumn());
    }

    public int paramNoByColumnType(int index) {
        this.check();
        if (this.info.preparedParams == null || index < 0 || index >= this.info.preparedParamsSize) {
            return -1;
        }
        MimdbSearchElement em = this.info.preparedParams[index];
        if (em.isOffLimit()) {
            return 2;
        }
        return MimdbTableManager.getInstance().get(this.info.name).getColumnType(em.getColumn());
    }

    public boolean isPamraNoByListParam(int index) {
        this.check();
        if (this.info.preparedParams == null || index < 0 || index >= this.info.preparedParamsSize) {
            return false;
        }
        int type = this.info.preparedParams[index].getType();
        return type == 7 || type == 9;
    }

    public MimdbQueryPrepared setOffset(int off) {
        this.check();
        this.viewOffset = off <= -1 ? -1 : off;
        return this;
    }

    public MimdbQueryPrepared setLimit(int limit) {
        this.check();
        this.viewLimit = limit <= -1 ? -1 : limit;
        return this;
    }

    public QueryCompileInfo getInfo() {
        this.check();
        return this.info;
    }

    public String getSql() throws Exception {
        this.check();
        return this.info.getSql(MimdbTableManager.getInstance());
    }

    public MimdbResult executeQuery() throws Exception {
        return this.executeQuery(false);
    }

    public MimdbResult executeQuery(boolean mode) throws Exception {
        MimdbTable table;
        this.check();
        if (this.info.dbId == -1L) {
            throw new MimdbException("\u5fc5\u8981\u306a\u30c7\u30fc\u30bf\u304c\u5b58\u5728\u3057\u307e\u305b\u3093");
        }
        int pOff = this.info.defOffset;
        int pLmt = this.info.defLimit;
        int preparedParamsSize = this.info.preparedParamsSize;
        String name = this.info.name;
        EqualsNoList columns = this.info.columns;
        boolean countFlag = this.info.countFlag;
        SortElement sort = this.info.sort;
        WhereBlock block = this.info.block;
        if (preparedParamsSize > 0) {
            if (this.executionParams == null) {
                throw new MimdbException("\u5b9f\u884c\u30d1\u30e9\u30e1\u30fc\u30bf\u304c\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
            }
            for (int i = 0; i < preparedParamsSize; ++i) {
                MimdbSearchElement em = this.executionParams[i];
                if (em == null) {
                    throw new MimdbException("[" + i + "]\u756a\u76ee\u306e\u30d1\u30e9\u30e1\u30fc\u30bf\u304c\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
                }
                if (em.getType() != 30) continue;
                if ("offset".equals(em.getColumn())) {
                    pOff = MimdbUtils.convertInt(em.getValue());
                    continue;
                }
                pLmt = MimdbUtils.convertInt(em.getValue());
            }
        }
        if ((table = (MimdbTable)MimdbTableManager.getInstance().get(name)) == null) {
            throw new MimdbException("\u6307\u5b9a\u30c6\u30fc\u30d6\u30eb(" + name + ")\u60c5\u5831\u306f\u5b58\u5728\u3057\u307e\u305b\u3093");
        }
        if (table.getDbId() != this.info.dbId) {
            if (mode) {
                throw new MimdbException("\u5bfe\u8c61\u30c6\u30fc\u30d6\u30eb[" + name + "]\u306f\u66f4\u65b0\u3055\u308c\u3066\u3044\u307e\u3059");
            }
            this.info.dbId = table.getDbId();
        }
        long dbId = this.info.dbId;
        this.initSortElement(table, sort);
        int off = this.viewOffset;
        int limit = this.viewLimit;
        this.executionParams = null;
        this.viewOffset = -1;
        this.viewLimit = -1;
        if (off == -1 && limit == -1) {
            if (pOff != -1) {
                off = pOff;
            }
            if (pLmt != -1) {
                limit = pLmt;
            }
        }
        if (off != -1 || limit != -1) {
            if (off != -1) {
                if (limit == -1) {
                    limit = 999999999;
                }
            } else if (limit != -1) {
                off = 0;
            }
        }
        ResultCache cache = ResultCache.get();
        ResultImpl ret = cache.result;
        if (block == null || block.size() == 0) {
            if (countFlag) {
                CountMetaDataImpl meta = cache.countMeta;
                cache.countMeta.create(ret);
                CountResultRowImpl row = cache.countRow;
                cache.countRow.create(ret, table.size());
                ret.create(dbId, table, cache, meta, row, null, 1, 1);
            } else {
                MetaDataImpl meta = cache.meta;
                cache.meta.create(ret, columns);
                ResultRowImpl row = cache.row;
                cache.row.create(ret);
                cache.pointer.create(table.mainTable, sort, off, limit);
                cache.pointer.execute();
                ret.create(dbId, table, cache, meta, row, cache.pointer, cache.pointer.resultLength(), table.size());
            }
            return ret;
        }
        MimdbMiddleSearch res = MimdbQueryPrepared.search(dbId, table, null, block);
        if (res == null || res.size() <= 0) {
            if (countFlag) {
                CountMetaDataImpl meta = cache.countMeta;
                cache.countMeta.create(ret);
                CountResultRowImpl row = cache.countRow;
                cache.countRow.create(ret, 0);
                ret.create(dbId, table, cache, meta, row, null, 1, 1);
            } else {
                MetaDataImpl meta = cache.meta;
                cache.meta.create(ret, columns);
                ResultRowImpl row = cache.row;
                cache.row.create(ret);
                cache.pointer.createZero(table.mainTable, sort, off, limit);
                cache.pointer.execute();
                ret.create(dbId, table, cache, meta, row, cache.pointer, cache.pointer.resultLength(), table.size());
            }
            return ret;
        }
        if (countFlag) {
            CountMetaDataImpl meta = cache.countMeta;
            cache.countMeta.create(ret);
            CountResultRowImpl row = cache.countRow;
            cache.countRow.create(ret, res.size());
            ret.create(dbId, table, cache, meta, row, null, 1, 1);
        } else {
            MetaDataImpl meta = cache.meta;
            cache.meta.create(ret, columns);
            ResultRowImpl row = cache.row;
            cache.row.create(ret);
            cache.pointer.create(res, table.mainTable, sort, off, limit);
            cache.pointer.execute();
            ret.create(dbId, table, cache, meta, row, cache.pointer, cache.pointer.resultLength(), table.size());
        }
        return ret;
    }

    private static final MimdbMiddleSearch search(long dbId, MimdbTable table, MimdbMiddleSearch res, WhereBlock block) throws Exception {
        int len = block.size();
        int andor = -1;
        block4: for (int i = 0; i < len; ++i) {
            Object o = block.get(i);
            if (o instanceof WhereBlock) {
                MimdbMiddleSearch blockRes = MimdbQueryPrepared.search(dbId, table, null, (WhereBlock)o);
                if (blockRes == null) {
                    if (andor != -1 && andor != 0) continue;
                    res = null;
                    continue;
                }
                if (andor == 0) {
                    res.and(blockRes);
                    continue;
                }
                if (andor == 1) {
                    if (res == null || res.size() <= 0) {
                        res = blockRes;
                    } else {
                        res.or(blockRes);
                    }
                    res = res.size() > 0 ? res : null;
                    continue;
                }
                res = blockRes.size() > 0 ? blockRes : null;
                continue;
            }
            MimdbSearchElement em = (MimdbSearchElement)o;
            switch (em.getType()) {
                case 20: {
                    andor = 0;
                    continue block4;
                }
                case 21: {
                    andor = 1;
                    continue block4;
                }
                default: {
                    if (andor == -1) {
                        res = table.getIndex(em.getColumnNo()).search(em);
                    } else if (andor == 0) {
                        if (res != null) {
                            res = table.getIndex(em.getColumnNo()).and(em, res);
                        }
                    } else if (andor == 1) {
                        res = table.getIndex(em.getColumnNo()).or(em, res);
                    } else {
                        throw new MimdbException("\u4e0d\u660e\u306aand or\u6761\u4ef6\u304c\u691c\u51fa\u3055\u308c\u307e\u3057\u305f(column:" + em.toString() + " code:" + andor + ")");
                    }
                    andor = -1;
                }
            }
        }
        return res;
    }

    private final void initSortElement(MimdbTable table, SortElement sort) {
        if (sort == null || sort.sortNoList == null) {
            return;
        }
        if (sort.indexList == null) {
            int[] noList = sort.sortNoList;
            int len = noList.length;
            int[][] idx = new int[len][];
            for (int i = 0; i < len; ++i) {
                MimdbIndex index = table.getIndex(noList[i]);
                idx[i] = (int[])(index != null ? index.getSortNoList() : null);
            }
            sort.indexLength = len == 1 ? table.getIndex(noList[0]).getIndexSize() : -1;
            sort.indexList = idx;
        }
    }
}

