/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.mimdb.core;

import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.maachang.mimdb.core.MimdbBase;
import org.maachang.mimdb.core.util.AtomicNumber;
import org.maachang.mimdb.core.util.AtomicNumber32;

public final class MimdbUpdateLock
implements MimdbBase {
    private final AtomicNumber dbId = new AtomicNumber(0L);
    private ReentrantReadWriteLock rwLock = new ReentrantReadWriteLock();
    private AtomicNumber32 readFlag = new AtomicNumber32(0);
    private AtomicNumber32 writeFlag = new AtomicNumber32(0);

    protected MimdbUpdateLock() {
    }

    @Override
    public long getDbId() {
        return this.dbId.get();
    }

    public long update() {
        return this.dbId.inc();
    }

    public void setDbId(long id) {
        this.dbId.set(id);
    }

    public void writeBegin() {
        this.rwLock.writeLock().lock();
        this.writeFlag.inc();
    }

    public void writeEnd() {
        this.rwLock.writeLock().unlock();
        this.writeFlag.dec();
    }

    public void readBegin() {
        this.rwLock.readLock().lock();
        this.readFlag.inc();
    }

    public void readEnd() {
        this.rwLock.readLock().unlock();
        this.readFlag.dec();
    }

    public boolean isWriteLock() {
        return (long)this.writeFlag.get() > 0L;
    }

    public boolean isReadLock() {
        return (long)this.readFlag.get() > 0L;
    }
}

