/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.mimdb.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.maachang.mimdb.core.BaseTable;
import org.maachang.mimdb.core.MimdbResultRow;
import org.maachang.mimdb.core.MimdbRow;

class PrimaryResultRowImpl
extends MimdbResultRow {
    MimdbRow row;

    public PrimaryResultRowImpl(MimdbRow row) {
        this.row = row;
    }

    @Override
    public void clear() {
        this.row = null;
    }

    @Override
    public long getDbId() {
        return this.row.dbId;
    }

    @Override
    public String getName() {
        return this.row.getTableName();
    }

    public BaseTable getTable() {
        return this.row.getTable();
    }

    @Override
    public int getLineNo() {
        return 0;
    }

    public boolean isDesc() {
        return false;
    }

    @Override
    public Object getValue(int n) {
        return this.row.getValue(n);
    }

    @Override
    public void putAll(Map toMerge) {
    }

    @Override
    public boolean containsValue(Object value) {
        int len = this.row.getTable().columnLength;
        Object[] values = this.row.getValues();
        if (value == null) {
            for (int i = 0; i < len; ++i) {
                if (values[i] != null) continue;
                return true;
            }
        } else {
            for (int i = 0; i < len; ++i) {
                if (!value.equals(values[i])) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public Set entrySet() {
        return null;
    }

    @Override
    public Collection values() {
        int len = this.row.getTable().columnLength;
        ArrayList<Object> ret = new ArrayList<Object>(len);
        Object[] values = this.row.getValues();
        for (int i = 0; i < len; ++i) {
            ret.add(values[i]);
        }
        return ret;
    }

    @Override
    public Object put(Object name, Object value) {
        return null;
    }

    @Override
    public boolean containsKey(Object key) {
        if (key instanceof String) {
            return this.row.getTable().columnsMap.containsKey(((String)key).trim().toLowerCase());
        }
        if (key instanceof Number) {
            int n = ((Number)key).intValue();
            return n >= 0 && n < this.row.getTable().columnLength;
        }
        return false;
    }

    @Override
    public Object get(Object key) {
        int n;
        if (key instanceof String) {
            Integer n2 = this.row.getTable().columnsMap.get(((String)key).trim().toLowerCase());
            if (n2 != null) {
                return this.row.getValue(n2);
            }
        } else if (key instanceof Number && (n = ((Number)key).intValue()) >= 0 && n < this.row.getTable().columnLength) {
            return this.row.getValue(n);
        }
        return null;
    }

    @Override
    public Object remove(Object key) {
        return null;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public Set keySet() {
        HashSet<Object> ret = new HashSet<Object>();
        this.getAllKey(ret);
        return ret;
    }

    @Override
    public int size() {
        return this.row.getTable().columnLength;
    }

    public void getAllKey(Set<Object> set) {
        int len = this.row.getTable().columnLength;
        String[] key = this.row.getTable().columns;
        for (int i = 0; i < len; ++i) {
            set.add(key[i]);
        }
    }

    public void getAllValues(Set<Object> set) {
        int len = this.row.getTable().columnLength;
        Object[] values = this.row.getValues();
        for (int i = 0; i < len; ++i) {
            set.add(values[i]);
        }
    }

    public String toString() {
        int len = this.row.getTable().columnLength;
        StringBuilder buf = new StringBuilder();
        String[] key = this.row.getTable().columns;
        Object[] values = this.row.getValues();
        buf.append("{");
        for (int i = 0; i < len; ++i) {
            if (i != 0) {
                buf.append(",");
            }
            if (values[i] instanceof String) {
                buf.append(key[i]).append(":\"").append(values[i]).append("\"");
                continue;
            }
            buf.append(key[i]).append(":").append(values[i]);
        }
        return buf.append("}").toString();
    }
}

