/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.mimdb.core;

import org.maachang.mimdb.MimdbException;
import org.maachang.mimdb.core.MimdbSearchElement;
import org.maachang.mimdb.core.util.ObjectList;

public final class QueryInfo {
    protected String name = null;
    protected final ObjectList<String> columns = new ObjectList();
    protected boolean allColumn = true;
    protected boolean countFlag = false;
    protected final ObjectList<MimdbSearchElement> where = new ObjectList();
    protected final ObjectList<String> sortList = new ObjectList();
    protected final ObjectList<Boolean> descList = new ObjectList();

    protected void finalize() throws Exception {
        this.clear();
    }

    public void clear() {
        this.name = null;
        this.columns.clear();
        this.allColumn = true;
        this.countFlag = false;
        this.where.clear();
        this.sortList.clear();
        this.descList.clear();
    }

    public void setTable(String table) throws Exception {
        if (table == null || (table = table.trim().toLowerCase()).length() <= 0) {
            throw new MimdbException("\u30c6\u30fc\u30d6\u30eb\u540d\u304c\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
        }
        this.name = table;
    }

    public String getName() {
        return this.name;
    }

    public void setViewColumn(String name) {
        if (name == null || (name = name.trim().toLowerCase()).length() <= 0) {
            throw new MimdbException("\u6307\u5b9a\u30ab\u30e9\u30e0\u540d\u306f\u5b58\u5728\u3057\u307e\u305b\u3093");
        }
        if ("*".equals(name)) {
            this.allColumn = true;
            this.countFlag = false;
        } else {
            this.columns.add(name);
            this.allColumn = false;
            this.countFlag = false;
        }
    }

    public void setViewCount() {
        this.countFlag = true;
    }

    public ObjectList<String> getViewColumn() {
        return this.columns;
    }

    public boolean isAllView() {
        return this.allColumn;
    }

    public boolean isCountView() {
        return this.countFlag;
    }

    public void addWhere(MimdbSearchElement search) throws Exception {
        if (search == null) {
            throw new MimdbException("\u691c\u7d22\u6761\u4ef6\u306f\u7121\u52b9\u3067\u3059");
        }
        this.where.add(search);
    }

    public ObjectList<MimdbSearchElement> getWhere() {
        return this.where;
    }

    public void addSortColumn(String name, boolean desc) throws Exception {
        if (name == null || (name = name.trim().toLowerCase()).length() <= 0) {
            throw new MimdbException("\u6307\u5b9a\u30ab\u30e9\u30e0\u540d\u306f\u5b58\u5728\u3057\u307e\u305b\u3093");
        }
        this.sortList.add(name);
        this.descList.add(desc);
    }

    public ObjectList<String> getSortColumn() {
        return this.sortList;
    }

    public ObjectList<Boolean> getDesc() {
        return this.descList;
    }

    public String getSql() throws Exception {
        int i;
        int len;
        if (this.name == null) {
            throw new MimdbException("\u30c6\u30fc\u30d6\u30eb\u540d\u304c\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
        }
        StringBuilder buf = new StringBuilder(1024);
        buf.append("SELECT ");
        if (this.countFlag) {
            buf.append("COUNT(*) ");
        } else if (this.allColumn) {
            buf.append("* ");
        } else {
            len = this.columns.size();
            for (i = 0; i < len; ++i) {
                if (i != 0) {
                    buf.append(", ");
                }
                buf.append(this.columns.get(i)).append(" ");
            }
        }
        buf.append("FROM ").append(this.name).append(" ");
        if (this.where.size() > 0) {
            buf.append("WHERE ");
            len = this.where.size();
            for (i = 0; i < len; ++i) {
                buf.append(this.where.get(i)).append(" ");
            }
        }
        if (this.sortList.size() > 0) {
            buf.append("ORDER BY ");
            len = this.sortList.size();
            for (i = 0; i < len; ++i) {
                buf.append(this.sortList.get(i)).append(" ");
                if (this.descList.get(i).booleanValue()) {
                    buf.append("DESC ");
                    continue;
                }
                buf.append("ASC ");
            }
        }
        return buf.append(";").toString();
    }
}

