/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.mimdb.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.maachang.mimdb.core.BaseTable;
import org.maachang.mimdb.core.MimdbResultRow;
import org.maachang.mimdb.core.RemoteResultImpl;
import org.maachang.mimdb.core.impl.EqualsNoList;

final class RemoteResultRow
extends MimdbResultRow {
    protected RemoteResultImpl parent;
    protected boolean countFlag;

    public RemoteResultRow() {
    }

    public RemoteResultRow(RemoteResultImpl parent) {
        this.create(parent);
    }

    protected void finalize() throws Exception {
        this.clear();
    }

    public void create(RemoteResultImpl parent) {
        this.parent = parent;
        this.countFlag = parent.compile.countFlag;
    }

    @Override
    public void clear() {
        this.parent = null;
    }

    @Override
    public long getDbId() {
        return this.parent.compile.dbId;
    }

    @Override
    public String getName() {
        return this.parent.compile.name;
    }

    public BaseTable getTable() {
        return this.parent.getTable();
    }

    @Override
    public int getLineNo() {
        return this.parent.nowRow;
    }

    private final EqualsNoList viewColumnList() {
        return this.parent.meta.viewColumnList;
    }

    private final Object[] src() {
        return this.parent.values[this.parent.nowRow - this.parent.position];
    }

    @Override
    public Object getValue(int n) {
        if (this.countFlag) {
            if (n != 0) {
                return null;
            }
            return this.src()[n];
        }
        EqualsNoList viewColumnList = this.viewColumnList();
        if (viewColumnList != null) {
            n = viewColumnList.src(n);
        }
        return this.src()[n];
    }

    private final int getColumnNameByNo(String name) {
        if (this.countFlag) {
            if ("count".equals(name)) {
                return -1;
            }
            return 0;
        }
        BaseTable table = this.parent.getTable();
        EqualsNoList viewColumnList = this.viewColumnList();
        if (viewColumnList != null) {
            int ret = table.getColumnNameByNo(name);
            if (!viewColumnList.equals(ret)) {
                return -1;
            }
            return ret;
        }
        return table.getColumnNameByNo(name);
    }

    @Override
    public void putAll(Map toMerge) {
    }

    @Override
    public boolean containsValue(Object value) {
        if (this.countFlag) {
            if (value instanceof Number) {
                return ((Number)value).equals(this.src()[0]);
            }
            return false;
        }
        EqualsNoList viewColumnList = this.viewColumnList();
        if (viewColumnList != null) {
            int[] vc = viewColumnList.arrays();
            int len = viewColumnList.size();
            Object[] values = this.src();
            if (value == null) {
                for (int i = 0; i < len; ++i) {
                    if (values[vc[i]] != null) continue;
                    return true;
                }
            } else {
                for (int i = 0; i < len; ++i) {
                    if (!value.equals(values[vc[i]])) continue;
                    return true;
                }
            }
        } else {
            BaseTable table = this.parent.getTable();
            int len = table.getColumnSize();
            Object[] values = this.src();
            if (value == null) {
                for (int i = 0; i < len; ++i) {
                    if (values[i] != null) continue;
                    return true;
                }
            } else {
                for (int i = 0; i < len; ++i) {
                    if (!value.equals(values[i])) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public Set entrySet() {
        return null;
    }

    @Override
    public Collection values() {
        if (this.countFlag) {
            ArrayList<Object> ret = new ArrayList<Object>();
            ret.add(this.src()[0]);
            return ret;
        }
        EqualsNoList viewColumnList = this.viewColumnList();
        if (viewColumnList != null) {
            int[] vc = viewColumnList.arrays();
            int len = viewColumnList.size();
            ArrayList<Object> ret = new ArrayList<Object>(len);
            Object[] values = this.src();
            for (int i = 0; i < len; ++i) {
                ret.add(values[vc[i]]);
            }
            return ret;
        }
        BaseTable table = this.parent.getTable();
        int len = table.getColumnSize();
        ArrayList<Object> ret = new ArrayList<Object>(len);
        Object[] values = this.src();
        for (int i = 0; i < len; ++i) {
            ret.add(values[i]);
        }
        return ret;
    }

    @Override
    public Object put(Object name, Object value) {
        return null;
    }

    @Override
    public boolean containsKey(Object key) {
        if (this.countFlag) {
            if (key instanceof String) {
                return "count".equals(key);
            }
            if (key instanceof Number) {
                return ((Number)key).intValue() == 0;
            }
            return false;
        }
        BaseTable table = this.parent.getTable();
        EqualsNoList viewColumnList = this.viewColumnList();
        if (viewColumnList != null) {
            if (key instanceof String) {
                return this.getColumnNameByNo((String)key) != -1;
            }
            if (key instanceof Number) {
                int n = ((Number)key).intValue();
                return n >= 0 && n < viewColumnList.size();
            }
        } else {
            if (key instanceof String) {
                return table.getColumnNameByNo(((String)key).trim().toLowerCase()) != -1;
            }
            if (key instanceof Number) {
                int n = ((Number)key).intValue();
                return n >= 0 && n < table.getColumnSize();
            }
        }
        return false;
    }

    @Override
    public Object get(Object key) {
        if (this.countFlag) {
            if (key instanceof String ? "count".equals(key) : key instanceof Number && ((Number)key).intValue() == 0) {
                return this.src()[0];
            }
            return null;
        }
        EqualsNoList viewColumnList = this.viewColumnList();
        if (viewColumnList != null) {
            if (key instanceof String) {
                int n = this.getColumnNameByNo((String)key);
                if (n != -1) {
                    return this.src()[n];
                }
                return null;
            }
            if (key instanceof Number) {
                int n = ((Number)key).intValue();
                if (n >= 0 && n < viewColumnList.size()) {
                    return this.src()[viewColumnList.src(n)];
                }
                return null;
            }
        } else {
            BaseTable table = this.parent.getTable();
            if (key instanceof String) {
                int n = table.getColumnNameByNo(((String)key).trim().toLowerCase());
                if (n == -1) {
                    return null;
                }
                return this.src()[n];
            }
            if (key instanceof Number) {
                int n = ((Number)key).intValue();
                if (n >= 0 && n < table.getColumnSize()) {
                    return this.src()[n];
                }
                return null;
            }
        }
        return null;
    }

    @Override
    public Object remove(Object key) {
        return null;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public Set keySet() {
        HashSet<Object> ret = new HashSet<Object>();
        this.getAllKey(ret);
        return ret;
    }

    @Override
    public int size() {
        if (this.countFlag) {
            return 1;
        }
        EqualsNoList viewColumnList = this.viewColumnList();
        if (viewColumnList != null) {
            return viewColumnList.size();
        }
        return this.parent.getTable().getColumnSize();
    }

    public void getAllKey(Set<Object> set) {
        if (this.countFlag) {
            set.add("count");
        }
        BaseTable table = this.parent.getTable();
        EqualsNoList viewColumnList = this.viewColumnList();
        if (viewColumnList != null) {
            int[] vc = viewColumnList.arrays();
            int len = viewColumnList.size();
            String[] key = table.getColumns();
            for (int i = 0; i < len; ++i) {
                set.add(key[vc[i]]);
            }
        } else {
            int len = table.getColumnSize();
            String[] key = table.getColumns();
            for (int i = 0; i < len; ++i) {
                set.add(key[i]);
            }
        }
    }

    public void getAllValues(Set<Object> set) {
        EqualsNoList viewColumnList;
        if (this.countFlag) {
            set.add(this.src()[0]);
        }
        if ((viewColumnList = this.viewColumnList()) != null) {
            int[] vc = viewColumnList.arrays();
            int len = viewColumnList.size();
            Object[] values = this.src();
            for (int i = 0; i < len; ++i) {
                set.add(values[vc[i]]);
            }
        } else {
            int len = this.parent.getTable().getColumnSize();
            Object[] values = this.src();
            for (int i = 0; i < len; ++i) {
                set.add(values[i]);
            }
        }
    }

    public String toString() {
        if (this.countFlag) {
            return "{" + "count" + ":" + this.src()[0] + "}";
        }
        BaseTable table = this.parent.getTable();
        EqualsNoList viewColumnList = this.viewColumnList();
        if (viewColumnList != null) {
            int[] vc = viewColumnList.arrays();
            int len = viewColumnList.size();
            StringBuilder buf = new StringBuilder();
            String[] key = table.getColumns();
            Object[] values = this.src();
            buf.append("{");
            for (int i = 0; i < len; ++i) {
                if (i != 0) {
                    buf.append(",");
                }
                if (values[vc[i]] instanceof String) {
                    buf.append(key[vc[i]]).append(":\"").append(values[vc[i]]).append("\"");
                    continue;
                }
                buf.append(key[vc[i]]).append(":").append(values[vc[i]]);
            }
            return buf.append("}").toString();
        }
        int len = table.getColumnSize();
        StringBuilder buf = new StringBuilder();
        String[] key = table.getColumns();
        Object[] values = this.src();
        buf.append("{");
        for (int i = 0; i < len; ++i) {
            if (i != 0) {
                buf.append(",");
            }
            if (values[i] instanceof String) {
                buf.append(key[i]).append(":\"").append(values[i]).append("\"");
                continue;
            }
            buf.append(key[i]).append(":").append(values[i]);
        }
        return buf.append("}").toString();
    }
}

