/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.mimdb.core;

import java.util.Arrays;
import org.maachang.mimdb.MimdbException;
import org.maachang.mimdb.core.MimdbMiddleSearch;
import org.maachang.mimdb.core.MimdbRow;
import org.maachang.mimdb.core.ResultArray;
import org.maachang.mimdb.core.SortElement;
import org.maachang.mimdb.core.util.ObjectLinkedList;

class ResultPointer {
    private static final int MAX_BACKET_SORT_LENGTH = 65535;
    protected MimdbRow[] src;
    protected SortElement sort;
    protected MimdbMiddleSearch msearch;
    protected int cursor = -1;
    protected int offset = -1;
    protected int limit = -1;
    protected boolean zeroFlag = false;
    protected PointerElement[] result;

    public void create(MimdbRow[] src, SortElement sort, int off, int limit) {
        this.create(null, src, sort, off, limit);
    }

    public void create(MimdbMiddleSearch msearch, MimdbRow[] src, SortElement sort, int off, int limit) {
        if (sort == null || sort.sortNoList == null) {
            sort = null;
        }
        this.msearch = msearch;
        this.src = src;
        this.sort = sort;
        this.offset = off;
        this.limit = limit;
        this.result = null;
        this.cursor = -1;
    }

    public void createZero(MimdbRow[] src, SortElement sort, int off, int limit) {
        this.create(null, src, sort, off, limit);
        this.zeroFlag = true;
    }

    public void clear() {
        this.msearch = null;
        this.src = null;
        this.sort = null;
        this.offset = -1;
        this.limit = -1;
        this.result = null;
        this.cursor = -1;
        this.zeroFlag = false;
    }

    public void execute() throws Exception {
        this.cursor = -1;
        if (this.zeroFlag) {
            this.result = null;
            return;
        }
        this.result = this.msearch != null ? this.searchToResult() : this.resultNotWhere();
        if (this.result != null) {
            this.cursor = 0;
        }
    }

    public int resultLength() {
        return this.result == null ? 0 : this.result.length;
    }

    public int get(int no) {
        if (this.result == null || no < 0 || this.result.length <= no) {
            throw new MimdbException("\u7bc4\u56f2\u3092\u8d85\u3048\u3066\u3044\u307e\u3059:" + no);
        }
        return this.result[no].no;
    }

    private final PointerElement[] createElement(int len) {
        PointerElement[] ret = new PointerElement[len];
        for (int i = 0; i < len; ++i) {
            ret[i] = new PointerElement();
        }
        return ret;
    }

    private final PointerElement[] searchToResult() throws Exception {
        int length = this.msearch.size();
        if (length == 0) {
            return null;
        }
        if (this.offset >= 0 && this.limit > 0) {
            if (this.offset >= length) {
                return null;
            }
            int off = this.offset;
            int lmt = this.limit;
            if ((off & 0x3FFFFFFF) + lmt >= length) {
                lmt = length - (off & 0x3FFFFFFF);
            }
            if (this.sort == null || this.sort.sortNoList == null) {
                ResultArray[] ret = this.createElement(lmt);
                this.msearch.getResultArray(ret, off);
                return ret;
            }
            ResultArray[] list = this.createElement(length);
            this.msearch.getResultArray(list);
            this.resultSort((PointerElement[])list);
            PointerElement[] ret = new PointerElement[lmt];
            System.arraycopy(list, off, ret, 0, lmt);
            return ret;
        }
        ResultArray[] ret = this.createElement(length);
        this.msearch.getResultArray(ret);
        if (this.sort != null && this.sort.sortNoList != null) {
            this.resultSort((PointerElement[])ret);
        }
        return ret;
    }

    private final PointerElement[] resultNotWhere() throws Exception {
        int len = this.src.length;
        if (this.offset >= 0 && this.limit > 0) {
            if (this.offset >= len) {
                return null;
            }
            int off = this.offset;
            int lmt = this.limit;
            if ((off & 0x3FFFFFFF) + lmt >= len) {
                lmt = len - (off & 0x3FFFFFFF);
            }
            if (lmt <= 0) {
                return null;
            }
            if (this.sort == null || this.sort.sortNoList == null) {
                int olLen = off + lmt;
                PointerElement[] ret = new PointerElement[lmt];
                int cnt = 0;
                for (int i = off; i < olLen; ++i) {
                    ret[cnt++] = new PointerElement(i);
                }
                return ret;
            }
            PointerElement[] list = new PointerElement[len];
            for (int i = 0; i < len; ++i) {
                list[i] = new PointerElement(i);
            }
            this.resultSort(list);
            PointerElement[] ret = new PointerElement[lmt];
            System.arraycopy(list, off, ret, 0, lmt);
            return ret;
        }
        PointerElement[] ret = new PointerElement[len];
        for (int i = 0; i < len; ++i) {
            ret[i] = new PointerElement(i);
        }
        if (this.sort != null && this.sort.sortNoList != null) {
            this.resultSort(ret);
        }
        return ret;
    }

    private final void resultSort(PointerElement[] list) {
        if (this.sort.indexList.length == 1 && this.sort.indexList[0] != null && list.length <= 65535 && this.sort.indexLength <= 65535) {
            this.backetSort(list);
        } else {
            Arrays.sort(list);
        }
    }

    private final void backetSort(PointerElement[] list) {
        ObjectLinkedList o2;
        int i;
        int[] idx = this.sort.indexList[0];
        ObjectLinkedList[] array = new ObjectLinkedList[this.sort.indexLength + 1];
        int len = list.length;
        for (i = 0; i < len; ++i) {
            PointerElement em = list[i];
            int n = idx[em.no] + 1;
            o2 = array[n];
            if (o2 == null) {
                array[n] = o2 = new ObjectLinkedList();
            }
            o2.offer(em);
        }
        if (this.sort.desc[0]) {
            int cnt = 0;
            for (i = array.length - 1; i >= 0; --i) {
                o2 = array[i];
                if (o2 == null) continue;
                cnt = o2.poll(list, cnt);
            }
        } else {
            int cnt = 0;
            for (ObjectLinkedList o2 : array) {
                if (o2 == null) continue;
                cnt = o2.poll(list, cnt);
            }
        }
    }

    private final class PointerElement
    extends ResultArray
    implements Comparable<PointerElement> {
        public PointerElement() {
        }

        public PointerElement(int n) {
            this.no = n;
        }

        @Override
        public final int compareTo(PointerElement n) {
            int[][] idxList = ResultPointer.this.sort.indexList;
            int[] sortNoList = ResultPointer.this.sort.sortNoList;
            boolean[] desc = ResultPointer.this.sort.desc;
            int nno = n.no;
            for (int i = idxList.length - 1; i >= 0; --i) {
                Object cc;
                Object c;
                int p;
                int[] idx;
                if (desc[i]) {
                    idx = idxList[i];
                    if (idx != null) {
                        p = idx[nno] - idx[this.no];
                        if (p == 0) continue;
                        return p;
                    }
                    c = ResultPointer.this.src[this.no].getValue(sortNoList[i]);
                    if (c == (cc = ResultPointer.this.src[nno].getValue(sortNoList[i]))) continue;
                    if (c == null || cc == null) {
                        if (c == null) {
                            return 1;
                        }
                        return -1;
                    }
                    p = ((Comparable)cc).compareTo(c);
                    if (p == 0) continue;
                    return p;
                }
                idx = idxList[i];
                if (idx != null) {
                    p = idx[this.no] - idx[nno];
                    if (p == 0) continue;
                    return p;
                }
                c = ResultPointer.this.src[this.no].getValue(sortNoList[i]);
                if (c == (cc = ResultPointer.this.src[nno].getValue(sortNoList[i]))) continue;
                if (c == null || cc == null) {
                    if (c == null) {
                        return -1;
                    }
                    return 1;
                }
                p = ((Comparable)c).compareTo(cc);
                if (p == 0) continue;
                return p;
            }
            return 0;
        }
    }
}

