/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.mimdb.core.impl;

import org.maachang.mimdb.core.ResultArray;
import org.maachang.mimdb.core.impl.Flags;
import org.maachang.mimdb.core.util.NumberKeyValue;

public abstract class AbstractLargeFlags
implements Flags {
    protected static final int TARGET_LENGTH = 32768;
    protected static final int INIT_LIST_LENGTH = 4;
    protected int max;
    protected int blockLength;
    protected NumberKeyValue<int[]> list;

    @Override
    public void destroy() {
        this.list = null;
        this.max = 0;
        this.blockLength = 0;
    }

    @Override
    public final void clear() {
        this.list = new NumberKeyValue(4);
    }

    @Override
    public abstract boolean isAnd();

    @Override
    public abstract void add(int var1);

    @Override
    public abstract void addArray(int[] var1);

    @Override
    public abstract void set(int var1, int var2);

    @Override
    public abstract void setArray(int[] var1, int var2);

    @Override
    public abstract void all();

    @Override
    public abstract void marge(Flags var1);

    @Override
    public final int get(int no) {
        int[] ff = this.list.get(no >> 9);
        if (ff != null) {
            int n = no & 0x1FF;
            return (ff[n >> 5] & 1 << (n & 0x1F)) >> (n & 0x1F);
        }
        return 0;
    }

    @Override
    public final int max() {
        return this.max;
    }

    @Override
    public final int size() {
        if (this.list.size() == 0) {
            return 0;
        }
        int ret = 0;
        this.list.reset();
        block0: while (this.list.hasNext()) {
            int code;
            int i;
            int n = this.list.next();
            int[] ff = this.list.nextValue();
            if (n + 1 == this.blockLength) {
                int mx = this.max - 32;
                for (i = 0; i < 16; ++i) {
                    if ((n << 9 | i << 5) >= mx) {
                        if (ff[i] == 0) continue block0;
                        code = ff[i];
                        int c = n << 9 | i << 5;
                        for (int j = 0; j < 32 && (c | j) < this.max; ++j) {
                            if ((code & 1 << j) == 0) continue;
                            ++ret;
                        }
                        continue block0;
                    }
                    if (ff[i] == 0) continue;
                    code = ff[i];
                    code = (code & 0x55555555) + (code >> 1 & 0x55555555);
                    code = (code & 0x33333333) + (code >> 2 & 0x33333333);
                    code = (code & 0xF0F0F0F) + (code >> 4 & 0xF0F0F0F);
                    code = (code & 0xFF00FF) + (code >> 8 & 0xFF00FF);
                    ret += (code & 0xFFFF) + (code >> 16 & 0xFFFF);
                }
                continue;
            }
            for (i = 0; i < 16; ++i) {
                if (ff[i] == 0) continue;
                code = ff[i];
                code = (code & 0x55555555) + (code >> 1 & 0x55555555);
                code = (code & 0x33333333) + (code >> 2 & 0x33333333);
                code = (code & 0xF0F0F0F) + (code >> 4 & 0xF0F0F0F);
                code = (code & 0xFF00FF) + (code >> 8 & 0xFF00FF);
                ret += (code & 0xFFFF) + (code >> 16 & 0xFFFF);
            }
        }
        return ret;
    }

    @Override
    public final int getResultArray(ResultArray[] out) {
        if (this.list.size() == 0 || out.length == 0) {
            return 0;
        }
        int ret = 0;
        int oLen = out.length;
        this.list.reset();
        block0: while (this.list.hasNext()) {
            int j;
            int code;
            int c;
            int i;
            int n = this.list.next();
            int[] ff = this.list.nextValue();
            if (n + 1 == this.blockLength) {
                int mx = this.max - 32;
                for (i = 0; i < 16; ++i) {
                    c = n << 9 | i << 5;
                    if (c >= mx) {
                        if (ff[i] == 0) continue block0;
                        code = ff[i];
                        for (j = 0; j < 32 && (c | j) < this.max; ++j) {
                            if ((code & 1 << j) == 0) continue;
                            out[ret++].no = c | j;
                            if (ret != oLen) continue;
                            return ret;
                        }
                        continue block0;
                    }
                    if (ff[i] == 0) continue;
                    if (ret + 32 >= oLen) {
                        if (ff[i] == -1) {
                            for (j = 0; j < 32; ++j) {
                                out[ret++].no = c | j;
                                if (ret != oLen) continue;
                                return ret;
                            }
                            continue;
                        }
                        code = ff[i];
                        for (j = 0; j < 32; ++j) {
                            if ((code & 1 << j) == 0) continue;
                            out[ret++].no = c | j;
                            if (ret != oLen) continue;
                            return ret;
                        }
                        continue;
                    }
                    if (ff[i] == -1) {
                        for (j = 0; j < 32; ++j) {
                            out[ret++].no = c | j;
                        }
                        continue;
                    }
                    code = ff[i];
                    for (j = 0; j < 32; ++j) {
                        if ((code & 1 << j) == 0) continue;
                        out[ret++].no = c | j;
                    }
                }
                continue;
            }
            for (i = 0; i < 16; ++i) {
                if (ff[i] == 0) continue;
                c = n << 9 | i << 5;
                if (ret + 32 >= oLen) {
                    if (ff[i] == -1) {
                        for (j = 0; j < 32; ++j) {
                            out[ret++].no = c | j;
                            if (ret != oLen) continue;
                            return ret;
                        }
                        continue;
                    }
                    code = ff[i];
                    for (j = 0; j < 32; ++j) {
                        if ((code & 1 << j) == 0) continue;
                        out[ret++].no = c | j;
                        if (ret != oLen) continue;
                        return ret;
                    }
                    continue;
                }
                if (ff[i] == -1) {
                    for (j = 0; j < 32; ++j) {
                        out[ret++].no = c | j;
                    }
                    continue;
                }
                code = ff[i];
                for (j = 0; j < 32; ++j) {
                    if ((code & 1 << j) == 0) continue;
                    out[ret++].no = c | j;
                }
            }
        }
        return ret;
    }

    @Override
    public final int getResultArray(ResultArray[] out, int off) {
        if (this.list.size() == 0 || out.length == 0) {
            return 0;
        }
        if (off <= 0) {
            return this.getResultArray(out);
        }
        int pos = 0;
        int cnt = 0;
        int oLen = out.length;
        this.list.reset();
        block0: while (this.list.hasNext()) {
            int j;
            int code;
            int c;
            int i;
            int n = this.list.next();
            int[] ff = this.list.nextValue();
            if (n + 1 == this.blockLength) {
                int mx = this.max - 32;
                for (i = 0; i < 16; ++i) {
                    c = n << 9 | i << 5;
                    if (c >= mx) {
                        if (ff[i] == 0) continue block0;
                        code = ff[i];
                        for (j = 0; j < 32 && (c | j) < this.max; ++j) {
                            if ((code & 1 << j) == 0 || ++pos <= off) continue;
                            out[cnt++].no = c | j;
                            if (cnt != oLen) continue;
                            return cnt;
                        }
                        continue block0;
                    }
                    if (ff[i] == 0) continue;
                    if (cnt + 32 >= oLen) {
                        if (ff[i] == -1) {
                            for (j = 0; j < 32; ++j) {
                                if (++pos <= off) continue;
                                out[cnt++].no = c | j;
                                if (cnt != oLen) continue;
                                return cnt;
                            }
                            continue;
                        }
                        code = ff[i];
                        for (j = 0; j < 32; ++j) {
                            if ((code & 1 << j) == 0 || ++pos <= off) continue;
                            out[cnt++].no = c | j;
                            if (cnt != oLen) continue;
                            return cnt;
                        }
                        continue;
                    }
                    if (ff[i] == -1) {
                        for (j = 0; j < 32; ++j) {
                            if (++pos <= off) continue;
                            out[cnt++].no = c | j;
                        }
                        continue;
                    }
                    code = ff[i];
                    for (j = 0; j < 32; ++j) {
                        if ((code & 1 << j) == 0 || ++pos <= off) continue;
                        out[cnt++].no = c | j;
                    }
                }
                continue;
            }
            for (i = 0; i < 16; ++i) {
                if (ff[i] == 0) continue;
                if (pos < off) {
                    code = ff[i];
                    code = (code & 0x55555555) + (code >> 1 & 0x55555555);
                    code = (code & 0x33333333) + (code >> 2 & 0x33333333);
                    code = (code & 0xF0F0F0F) + (code >> 4 & 0xF0F0F0F);
                    int npos = ((code = (code & 0xFF00FF) + (code >> 8 & 0xFF00FF)) & 0xFFFF) + (code >> 16 & 0xFFFF);
                    if (npos + pos < off) {
                        pos += npos;
                        continue;
                    }
                } else {
                    c = n << 9 | i << 5;
                    if (cnt + 32 >= oLen) {
                        if (ff[i] == -1) {
                            for (j = 0; j < 32; ++j) {
                                out[cnt++].no = c | j;
                                if (cnt != oLen) continue;
                                return cnt;
                            }
                            continue;
                        }
                        code = ff[i];
                        for (j = 0; j < 32; ++j) {
                            if ((code & 1 << j) == 0) continue;
                            out[cnt++].no = c | j;
                            if (cnt != oLen) continue;
                            return cnt;
                        }
                        continue;
                    }
                    if (ff[i] == -1) {
                        for (j = 0; j < 32; ++j) {
                            out[cnt++].no = c | j;
                        }
                        continue;
                    }
                    code = ff[i];
                    for (j = 0; j < 32; ++j) {
                        if ((code & 1 << j) == 0) continue;
                        out[cnt++].no = c | j;
                    }
                    continue;
                }
                c = n << 9 | i << 5;
                if (cnt + 32 >= oLen) {
                    if (ff[i] == -1) {
                        for (j = 0; j < 32; ++j) {
                            if (++pos <= off) continue;
                            out[cnt++].no = c | j;
                            if (cnt != oLen) continue;
                            return cnt;
                        }
                        continue;
                    }
                    code = ff[i];
                    for (j = 0; j < 32; ++j) {
                        if ((code & 1 << j) == 0 || ++pos <= off) continue;
                        out[cnt++].no = c | j;
                        if (cnt != oLen) continue;
                        return cnt;
                    }
                    continue;
                }
                if (ff[i] == -1) {
                    for (j = 0; j < 32; ++j) {
                        if (++pos <= off) continue;
                        out[cnt++].no = c | j;
                    }
                    continue;
                }
                code = ff[i];
                for (j = 0; j < 32; ++j) {
                    if ((code & 1 << j) == 0 || ++pos <= off) continue;
                    out[cnt++].no = c | j;
                }
            }
        }
        return cnt;
    }
}

